/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.dmg;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.abstracts.Service;
import com.inet.gradle.setup.dmg.AbstractOSXApplicationBuilder;
import com.inet.gradle.setup.dmg.Dmg;
import com.inet.gradle.setup.dmg.PreferencesLink;
import com.inet.gradle.setup.util.Logging;
import com.inet.gradle.setup.util.ReplacingInputStream;
import com.inet.gradle.setup.util.ResourceUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.GradleBuild;

public class OSXPrefPaneCreator
extends AbstractOSXApplicationBuilder<Dmg, SetupBuilder> {
    private File buildDir;
    private Project project;
    private Service service;
    private String displayName;
    private String internalName;
    private File prefPaneSource;

    protected OSXPrefPaneCreator(Dmg task, SetupBuilder setup, FileResolver fileResolver, Service service) {
        super(task, setup, fileResolver);
        this.buildDir = task.getTemporaryDir();
        this.project = task.getProject();
        this.service = service;
        this.displayName = service.getDisplayName();
        this.internalName = this.displayName.replaceAll("[^A-Za-z0-9]", "");
        GradleBuild gradleBuild = (GradleBuild)this.project.getTasks().create("OSXPrefPaneBuildTask-" + this.internalName, GradleBuild.class);
        gradleBuild.setDescription("Run the xcodebuild task for the prefpane.");
        gradleBuild.setTasks(Arrays.asList("clean", "xcodebuild"));
        task.dependsOn(new Object[]{gradleBuild});
        DefaultTask gradleBuildInit = (DefaultTask)this.project.getTasks().create("OSXPrefPaneBuildTask-Init-" + this.internalName, DefaultTask.class);
        gradleBuildInit.doFirst(t -> {
            try {
                this.prefPaneSource = this.unpackAndPatchPrefPaneSource(this.internalName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
            gradleBuild.setBuildFile(new File(this.prefPaneSource, "build.gradle"));
        });
        gradleBuild.dependsOn(new Object[]{gradleBuildInit});
    }

    void create() throws Exception {
        File prefPaneBinary = new File(this.prefPaneSource, "build/sym/Release/" + this.internalName + ".prefPane");
        if (!prefPaneBinary.exists()) {
            throw new GradleException("Failed to create the Preferences Pane.");
        }
        File resourcesOutput = new File(this.buildDir, this.displayName + ".app/Contents/Resources");
        File prefPaneLocation = new File(resourcesOutput, this.displayName + ".prefPane");
        Files.move(prefPaneBinary.toPath(), prefPaneLocation.toPath(), StandardCopyOption.REPLACE_EXISTING);
        File prefPaneContents = new File(prefPaneLocation, "Contents");
        Path iconPath = this.getApplicationIcon().toPath();
        Files.copy(iconPath, new File(prefPaneContents, "Resources/" + this.internalName + ".app/Contents/Resources/applet.icns").toPath(), StandardCopyOption.REPLACE_EXISTING);
        File prefPaneHelper = new File(prefPaneContents, "Resources/" + this.displayName + " Helper.app");
        Files.move(new File(prefPaneContents, "Resources/" + this.internalName + ".app").toPath(), prefPaneHelper.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Logging.sysout("Unpacked the Preference Pane to: " + prefPaneContents.getAbsolutePath());
        this.setApplicationFilePermissions(new File(prefPaneHelper, "Contents/MacOS/applet"));
        Files.copy(iconPath, new File(prefPaneLocation, "Contents/Resources/ProductIcon.icns").toPath(), StandardCopyOption.REPLACE_EXISTING);
        File prefPanePLIST = new File(prefPaneLocation, "Contents/Info.plist");
        String prefPaneIdentifier = ((Dmg)this.task).getApplicationIdentifier((SetupBuilder)this.getSetupBuilder());
        this.setPlistProperty(prefPanePLIST, ":CFBundleIdentifier", prefPaneIdentifier + ".prefPane");
        this.setPlistProperty(prefPanePLIST, ":CFBundleName", this.displayName + " Preference Pane");
        this.setPlistProperty(prefPanePLIST, ":CFBundleExecutable", this.internalName);
        this.setPlistProperty(prefPanePLIST, ":NSPrefPaneIconLabel", this.displayName);
        this.addPlistProperty(prefPanePLIST, ":NSPrefPaneHelperApplication", "String", this.displayName + " Helper");
        this.addPlistProperty(prefPanePLIST, ":NSAppleEventsUsageDescription", "String", "Helper application to provide priviledged access to " + this.displayName);
        File sudoPLIST = new File(prefPaneHelper, "Contents/Info.plist");
        this.setPlistProperty(sudoPLIST, ":CFBundleIdentifier", prefPaneIdentifier + ".prefPane.helper");
        this.setPlistProperty(sudoPLIST, ":CFBundleName", this.displayName + " Helper");
        this.setPlistProperty(sudoPLIST, ":CFBundleExecutable", "applet");
        this.addPlistProperty(sudoPLIST, ":NSAppleEventsUsageDescription", "String", "Helper application to provide priviledged access to " + this.displayName);
        File servicePLIST = new File(prefPaneLocation, "Contents/Resources/service.plist");
        this.setPlistProperty(servicePLIST, ":Name", this.displayName);
        this.setPlistProperty(servicePLIST, ":Label", this.service.getId());
        this.setPlistProperty(servicePLIST, ":Description", this.service.getDescription());
        this.setPlistProperty(servicePLIST, ":Version", ((Dmg)this.task).getVersion());
        this.setPlistProperty(servicePLIST, ":KeepAlive", String.valueOf(this.service.isKeepAlive()));
        this.setPlistProperty(servicePLIST, ":RunAtBoot", String.valueOf(this.service.isStartOnBoot()));
        this.setPlistProperty(servicePLIST, ":RunAtLoad", "true");
        if (((Dmg)this.task).getDaemonUser() != "root") {
            this.addPlistProperty(servicePLIST, ":UserName", "String", ((Dmg)this.task).getDaemonUser());
            this.addPlistProperty(servicePLIST, ":GroupName", "String", ((Dmg)this.task).getDaemonUser());
        }
        this.deletePlistProperty(servicePLIST, ":starter");
        for (int i = 0; i < ((Dmg)this.task).getPreferencesLinks().size(); ++i) {
            if (i == 0) {
                this.addPlistProperty(servicePLIST, ":starter", "array", null);
            }
            PreferencesLink preferencesLink = ((Dmg)this.task).getPreferencesLinks().get(i);
            this.addPlistProperty(servicePLIST, ":starter:", "dict", null);
            this.addPlistProperty(servicePLIST, ":starter:" + i + ":title", "string", preferencesLink.getTitle());
            this.addPlistProperty(servicePLIST, ":starter:" + i + ":action", "string", preferencesLink.getAction());
            this.addPlistProperty(servicePLIST, ":starter:" + i + ":asuser", "string", ((Dmg)this.task).getDaemonUser());
            this.addPlistProperty(servicePLIST, ":starter:" + i + ":asroot", "bool", preferencesLink.isRunAsRoot() ? "YES" : "NO");
        }
        ResourceUtils.deleteDirectory(this.prefPaneSource.toPath());
    }

    private File unpackAndPatchPrefPaneSource(final String internalName) throws Exception {
        String configName = "prefPaneSource";
        Configuration config = (Configuration)this.project.getConfigurations().findByName(configName);
        if (config == null) {
            config = (Configuration)this.project.getConfigurations().create(configName);
            config.setVisible(false);
            config.setTransitive(false);
            DependencyHandler dependencies = this.project.getDependencies();
            dependencies.add(configName, (Object)"org.openbakery.xcode-plugin:0.15.2");
        }
        File outputDir = new File(this.buildDir, internalName);
        outputDir.mkdirs();
        URL dirURL = OSXPrefPaneCreator.class.getClassLoader().getResource("com/inet/gradle/setup/dmg/preferences/build.gradle");
        String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
        File jar = new File(URLDecoder.decode(jarPath, "UTF-8"));
        ResourceUtils.unZipIt(jar, outputDir, "com/inet/gradle/setup/dmg/preferences", entryName -> entryName.replaceAll("SetupBuilderOSXPrefPane", internalName), inputStream -> new ReplacingInputStream((InputStream)inputStream, (Map<byte[], byte[]>)new HashMap<byte[], byte[]>(){
            {
                this.put("SetupBuilderOSXPrefPane".getBytes(), internalName.getBytes());
            }
        }));
        return outputDir;
    }
}

