/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.dmg;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.abstracts.DesktopStarter;
import com.inet.gradle.setup.abstracts.Service;
import com.inet.gradle.setup.dmg.AbstractOSXApplicationBuilder;
import com.inet.gradle.setup.dmg.Dmg;
import com.inet.gradle.setup.dmg.OSXPrefPaneCreator;
import java.io.File;
import org.gradle.api.internal.file.FileResolver;

public class OSXApplicationBuilder
extends AbstractOSXApplicationBuilder<Dmg, SetupBuilder> {
    private Service service;
    private OSXPrefPaneCreator prefPaneCreator;

    protected OSXApplicationBuilder(Dmg task, SetupBuilder setup, FileResolver fileResolver) {
        super(task, setup, fileResolver);
    }

    void configSubTasks(Service service) {
        this.service = service;
        this.prefPaneCreator = new OSXPrefPaneCreator((Dmg)this.task, (SetupBuilder)this.getSetupBuilder(), this.fileResolver, service);
    }

    Service getService() {
        return this.service;
    }

    void buildService() throws Throwable {
        if (this.service.getExecutable() == null || this.service.getExecutable().isEmpty()) {
            this.service.setExecutable(this.service.getId());
        }
        System.err.println("Having executable of: '" + this.service.getExecutable() + "'");
        this.prepareApplication(this.service, false);
        this.finishApplication();
        this.copyBundleFiles(this.service);
        this.prefPaneCreator.create();
    }

    void buildApplication(DesktopStarter application) throws Exception {
        if (application.getExecutable() == null || application.getExecutable().isEmpty()) {
            application.setExecutable(((SetupBuilder)this.getSetupBuilder()).getAppIdentifier());
        }
        this.prepareApplication(application, false);
        this.setDocumentTypes(application.getDocumentType());
        for (String scheme : application.getSchemes()) {
            this.addScheme(scheme);
        }
        this.finishApplication();
        this.copyBundleFiles(application);
        if (((Dmg)this.task).getCodeSign() != null) {
            ((Dmg)this.task).getCodeSign().signApplication(new File(this.buildDir, application.getDisplayName() + ".app"));
        }
    }
}

