/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.dmg;

import com.inet.gradle.setup.abstracts.AbstractBuilder;
import com.inet.gradle.setup.abstracts.AbstractSetupBuilder;
import com.inet.gradle.setup.abstracts.AbstractTask;
import com.inet.gradle.setup.abstracts.Application;
import com.inet.gradle.setup.abstracts.DocumentType;
import com.inet.gradle.setup.dmg.Dmg;
import com.inet.gradle.setup.util.Logging;
import com.oracle.appbundler.AppBundlerTask;
import com.oracle.appbundler.Architecture;
import com.oracle.appbundler.Argument;
import com.oracle.appbundler.BundleDocument;
import com.oracle.appbundler.Option;
import com.oracle.appbundler.Runtime;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.Project;
import org.codehaus.groovy.control.ConfigurationException;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.FileResolver;

public abstract class AbstractOSXApplicationBuilder<T extends AbstractTask, S extends AbstractSetupBuilder>
extends AbstractBuilder<T, S> {
    private S setup;
    private AppBundlerTask appBundler;

    protected AbstractOSXApplicationBuilder(T task, S setup, FileResolver fileResolver) {
        super(task, fileResolver);
        this.setup = setup;
        this.appBundler = new AppBundlerTask();
    }

    protected void prepareApplication(Application application, boolean isJNLPBuild) throws Exception {
        String appName = application.getDisplayName();
        Logging.sysout("BuildDir now: " + this.buildDir);
        this.appBundler.setOutputDirectory(this.buildDir);
        this.appBundler.setName(appName);
        this.appBundler.setDisplayName(appName);
        String version = this.task.getVersion();
        this.appBundler.setVersion(version);
        int idx = version.indexOf(46);
        if (idx >= 0 && (idx = version.indexOf(46, idx + 1)) >= 0) {
            version = version.substring(0, idx);
        }
        String mainJar = application.getMainJar();
        if (application.getWorkDir() != null) {
            this.appBundler.setWorkingDirectory(new File(new File("$APP_ROOT/Contents/Java"), application.getWorkDir()).toString());
            mainJar = new File(new File(application.getWorkDir()), mainJar).toString();
        }
        this.appBundler.setShortVersion(version);
        this.appBundler.setExecutableName(application.getExecutable());
        String identifier = ((AbstractSetupBuilder)this.setup).getAppIdentifier();
        if (appName != ((AbstractSetupBuilder)this.setup).getApplication()) {
            identifier = identifier + "." + appName.replaceAll("^A-Za-z0-9]", "");
        }
        this.appBundler.setIdentifier(identifier);
        if (!isJNLPBuild) {
            if (application.getMainClass() == null) {
                throw new ConfigurationException("A main class is required for the application. You have to configure at least the following:\n\n\tsetupBuilder {\n\t\t[..]\n\t\tmainClass = 'your.org.main.class'\n\t}\n\n");
            }
            this.appBundler.setMainClassName(application.getMainClass());
            if (mainJar == null) {
                throw new ConfigurationException("A main jar file is required for the application. You have to configure at least the following:\n\n\tsetupBuilder {\n\t\t[..]\n\t\tmainJar = '/path/to/yourMain.jar'\n\t}\n\n");
            }
            this.appBundler.setJarLauncherName(mainJar);
            application.getJavaVMArguments().forEach(arg -> {
                Option argument = new Option();
                argument.setValue((String)arg);
                this.appBundler.addConfiguredOption(argument);
            });
            Arrays.asList(application.getStartArguments().split(" ")).forEach(arg -> {
                if (arg.isEmpty()) {
                    return;
                }
                Argument argument = new Argument();
                argument.setValue((String)arg);
                this.appBundler.addConfiguredArgument(argument);
            });
        }
        this.appBundler.setIgnorePSN(true);
        this.appBundler.setCopyright(((AbstractSetupBuilder)this.setup).getCopyright());
        this.appBundler.setIcon(this.getApplicationIcon());
        Architecture x86_64 = new Architecture();
        x86_64.setName("x86_64");
        this.appBundler.addConfiguredArch(x86_64);
    }

    protected void finishApplication() {
        this.bundleJre();
        Project antProject = new Project();
        this.appBundler.setProject(antProject);
        this.appBundler.execute();
    }

    protected void setDocumentTypes(List<DocumentType> list) throws IOException {
        for (DocumentType doc : list) {
            BundleDocument bundle = new BundleDocument();
            bundle.setExtensions(String.join((CharSequence)",", doc.getFileExtension()));
            bundle.setName(doc.getName());
            bundle.setRole(doc.getRole());
            bundle.setIcon(this.getApplicationIcon().toString());
            this.appBundler.addConfiguredBundleDocument(bundle);
        }
    }

    protected void addScheme(String scheme) {
        if (scheme == null || scheme.isEmpty()) {
            return;
        }
        Argument schemeArgument = new Argument();
        schemeArgument.setValue(scheme);
        this.appBundler.addConfiguredScheme(schemeArgument);
    }

    protected void bundleJre() {
        File jreDir;
        Object jre = ((AbstractSetupBuilder)this.setup).getBundleJre();
        if (jre == null) {
            return;
        }
        try {
            jreDir = this.task.getProject().file(jre);
        }
        catch (Exception e) {
            jreDir = null;
        }
        if (jreDir == null || !jreDir.isDirectory()) {
            ArrayList<String> command = new ArrayList<String>();
            command.add("/usr/libexec/java_home");
            command.add("-v");
            command.add(jre.toString());
            command.add("-F");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.exec(command, null, baos);
            jreDir = new File(baos.toString().trim());
            if (!jreDir.isDirectory()) {
                throw new GradleException("bundleJre version " + jre + " can not be found in: " + jreDir);
            }
        }
        this.task.getProject().getLogger().lifecycle("\tbundle JRE: " + jreDir);
        Runtime runtime = new Runtime(jreDir);
        if (this.task instanceof Dmg) {
            List<String> include = ((Dmg)this.task).getJreIncludes();
            List<String> exclude = ((Dmg)this.task).getJreExcludes();
            runtime.appendIncludes(include.toArray(new String[include.size()]));
            runtime.appendExcludes(exclude.toArray(new String[exclude.size()]));
        } else {
            runtime.appendIncludes(new String[]{"jre/bin/java"});
        }
        this.appBundler.addConfiguredRuntime(runtime);
    }

    protected File getApplicationIcon() throws IOException {
        File icons = ((AbstractSetupBuilder)this.setup).getIconForType(this.buildDir, "icns");
        if (icons == null) {
            throw new ConfigurationException("You have to specify a valid icon file.\n\n\tPlease set the parameter 'icons' of the setupBuilder configuration to an existing '*.icns' file.\n\n");
        }
        return icons;
    }

    protected void setPlistProperty(File plist, String property, String value) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/libexec/PlistBuddy");
        command.add("-c");
        command.add("Set " + property + " " + value);
        command.add(plist.getAbsolutePath());
        this.exec(command);
    }

    protected void addPlistProperty(File plist, String property, String type, String value) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/libexec/PlistBuddy");
        command.add("-c");
        command.add("Add " + property + " " + type + " " + value);
        command.add(plist.getAbsolutePath());
        this.exec(command);
    }

    protected void deletePlistProperty(File plist, String property) {
        this.exec("/usr/libexec/PlistBuddy", "-c", "Delete " + property, plist.getAbsolutePath());
    }

    protected void copyBundleFiles(Application application) throws IOException {
        File destination = new File(this.buildDir, application.getDisplayName() + ".app");
        ((AbstractTask)this.getTask()).copyTo(new File(destination, "Contents/Java"));
        this.setApplicationFilePermissions(destination);
    }

    protected void setApplicationFilePermissions(File destination) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("chmod");
        command.add("-R");
        command.add("a+r");
        command.add(destination.getAbsolutePath());
        this.exec(command);
        command = new ArrayList();
        command.add("find");
        command.add(destination.getAbsolutePath());
        if (destination.isDirectory()) {
            command.add("-type");
            command.add("d");
        }
        command.add("-exec");
        command.add("chmod");
        command.add("a+x");
        command.add("{}");
        command.add(";");
        this.exec(command);
    }

    protected AppBundlerTask getAppBundler() {
        return this.appBundler;
    }

    protected S getSetupBuilder() {
        return this.setup;
    }
}

