/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.abstracts;

import com.inet.gradle.setup.SetupBuilder;
import groovy.lang.Closure;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.gradle.util.ConfigureUtil;

public class LocalizedResource {
    private Locale locale;
    private Object resource;
    private SetupBuilder setup;

    public LocalizedResource(SetupBuilder setup) {
        this.setup = setup;
    }

    public File getResource() {
        if (this.resource != null) {
            return this.setup.getProject().file(this.resource);
        }
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLanguage() {
        return this.locale.getLanguage();
    }

    public void setLocale(String locale) {
        this.locale = new Locale(locale);
    }

    public void setResource(Object resource) {
        this.resource = resource;
    }

    public static File getLocalizedResourceFile(List<LocalizedResource> list, String locale) {
        for (LocalizedResource res : list) {
            if (!locale.equalsIgnoreCase(res.getLanguage())) continue;
            return res.getResource();
        }
        return null;
    }

    public static void addLocalizedResource(SetupBuilder parent, List<LocalizedResource> holder, Object resource) {
        LocalizedResource res = new LocalizedResource(parent);
        if (resource instanceof Closure) {
            res = (LocalizedResource)ConfigureUtil.configure((Closure)((Closure)resource), (Object)res);
        } else {
            res.setLocale(parent.getDefaultResourceLanguage());
            res.setResource(resource);
        }
        holder.add(res);
    }
}

