/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.abstracts;

import com.inet.gradle.setup.abstracts.AbstractSetupBuilder;
import java.util.ArrayList;
import java.util.List;

public class DocumentType {
    private final AbstractSetupBuilder setup;
    private List<String> extensions;
    private String name;
    private String mimetype;
    private String role = "Viewer";
    private Object icons;

    DocumentType(AbstractSetupBuilder setup) {
        this.setup = setup;
    }

    public void fileExtension(String extension) {
        if (extension.startsWith("*.")) {
            extension = extension.substring(2);
        }
        if (this.extensions == null) {
            this.extensions = new ArrayList<String>();
        }
        this.extensions.add(extension);
    }

    public void fileExtension(List<String> extensions) {
        for (String extension : extensions) {
            this.fileExtension(extension);
        }
    }

    public void setFileExtension(String extension) {
        this.extensions = null;
        this.fileExtension(extension);
    }

    public List<String> getFileExtension() {
        return this.extensions;
    }

    public void setFileExtension(List<String> extensions) {
        this.extensions = extensions;
    }

    public String getName() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        return this.setup.getProject().getName() + " file";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMimetype() {
        if (this.mimetype != null && this.mimetype.trim().length() > 0) {
            return this.mimetype;
        }
        List<String> ext = this.getFileExtension();
        return "application/" + ext.get(0);
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Object getIcons() {
        if (this.icons != null) {
            return this.icons;
        }
        return this.setup.getIcons();
    }

    public void setIcons(Object icons) {
        this.icons = icons;
    }
}

