/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.abstracts;

import com.inet.gradle.setup.abstracts.SetupSources;
import com.inet.gradle.setup.image.ImageFactory;
import com.inet.gradle.setup.util.Logging;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.copy.CopySpecInternal;

public class AbstractSetupBuilder
implements SetupSources {
    protected final Project project;
    private final CopySpecInternal rootSpec;
    private Object destinationDir;
    private String vendor;
    private String application;
    private String version;
    private String appIdentifier;
    private String archiveName;
    private Object icons;
    private Object bundleJre;
    private String bundleJreTarget;
    private String mainClass;
    private String mainJar;
    private boolean failOnEmptyFrom = true;
    private String description;
    private String copyright;

    public AbstractSetupBuilder(Project project) {
        this.project = project;
        this.rootSpec = (CopySpecInternal)project.copySpec((Closure)null);
        this.setDestinationDir(new File("distributions"));
        Logging.sysout("setting default Destination to: " + this.getDestinationDir());
    }

    public CopySpecInternal getRootSpec() {
        return this.rootSpec;
    }

    public Project getProject() {
        return this.project;
    }

    public File getDestinationDir() {
        return new File(this.project.getBuildDir(), String.valueOf(this.destinationDir));
    }

    @Override
    public FileTree getSource() {
        FileTree allSource = this.rootSpec.buildRootResolver().getAllSource();
        if (allSource == null) {
            throw new IllegalArgumentException("You have to specify input sources for your application");
        }
        return allSource;
    }

    public void setDestinationDir(Object destinationDir) {
        this.destinationDir = destinationDir;
    }

    public String getVendor() {
        if (this.vendor != null) {
            return this.vendor;
        }
        return "My Company";
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getApplication() {
        if (this.application != null) {
            return this.application;
        }
        return this.project.getName();
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        Object version = this.project.getProperties().get("version");
        if (version != null && !"unspecified".equalsIgnoreCase((String)version)) {
            return version.toString();
        }
        return "1.0";
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAppIdentifier() {
        if (this.appIdentifier != null) {
            return this.appIdentifier;
        }
        Object name = this.project.getProperties().get("archivesBaseName");
        if (name != null) {
            return name.toString();
        }
        return this.project.getName();
    }

    public void setAppIdentifier(String identifier) {
        this.appIdentifier = identifier;
    }

    public String getArchiveName() {
        if (this.archiveName != null) {
            return this.archiveName;
        }
        return this.getAppIdentifier() + '-' + this.getVersion();
    }

    public void setArchiveName(String setupName) {
        this.archiveName = setupName;
    }

    public Object getIcons() {
        return this.icons;
    }

    public File getIconForType(File buildDir, String type) throws IOException {
        return ImageFactory.getImageFile(this.project, this.getIcons(), buildDir, type);
    }

    public void setIcons(Object icons) {
        this.icons = icons;
    }

    public Object getBundleJre() {
        return this.bundleJre;
    }

    public void setBundleJre(Object bundleJre) {
        this.bundleJre = bundleJre;
    }

    public String getBundleJreTarget() {
        if (this.bundleJreTarget != null) {
            if (this.bundleJreTarget.startsWith("/")) {
                this.bundleJreTarget = this.bundleJreTarget.substring(1);
            }
            if (this.bundleJreTarget.endsWith("/")) {
                this.bundleJreTarget = this.bundleJreTarget.substring(0, this.bundleJreTarget.length() - 1);
            }
            return this.bundleJreTarget;
        }
        return "jre";
    }

    public void setBundleJreTarget(String bundleJreTarget) {
        this.bundleJreTarget = bundleJreTarget;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getMainJar() {
        return this.mainJar;
    }

    public void setMainJar(String mainJar) {
        this.mainJar = mainJar;
    }

    public boolean isFailOnEmptyFrom() {
        return this.failOnEmptyFrom;
    }

    public void setFailOnEmptyFrom(boolean failOnEmptyFrom) {
        this.failOnEmptyFrom = failOnEmptyFrom;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCopyright() {
        if (this.copyright != null) {
            return this.copyright;
        }
        StringBuilder builder = new StringBuilder("\u00a9 Copyright ");
        builder.append(Calendar.getInstance().get(1));
        builder.append(" by ");
        builder.append(this.getVendor());
        return builder.toString();
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }
}

