/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.abstracts;

import com.inet.gradle.setup.abstracts.AbstractSetupBuilder;
import com.inet.gradle.setup.abstracts.AbstractTask;
import com.inet.gradle.setup.util.IndentationOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.process.internal.DefaultExecAction;

public abstract class AbstractBuilder<T extends AbstractTask, S extends AbstractSetupBuilder> {
    protected T task;
    protected FileResolver fileResolver;
    protected File buildDir;

    protected AbstractBuilder(T task, FileResolver fileResolver) {
        this.task = task;
        this.fileResolver = fileResolver;
        this.buildDir = task.getTemporaryDir();
    }

    protected void exec(ArrayList<String> parameters) {
        this.exec(parameters, null, null);
    }

    protected void exec(ArrayList<String> parameters, InputStream input, OutputStream output) {
        this.exec(parameters, input, output, false);
    }

    protected String exec(String ... parameters) {
        return this.exec(true, parameters);
    }

    protected String exec(boolean ignoreExitValue, String ... parameters) {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(parameters));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.exec(command, null, baos, ignoreExitValue);
        return baos.toString().trim();
    }

    protected void exec(ArrayList<String> parameters, InputStream input, OutputStream output, boolean ignoreExitValue) {
        StringBuilder log = new StringBuilder("\tCommand: ");
        for (String para : parameters) {
            if (para == null) {
                this.task.getProject().getLogger().lifecycle("Parameter not set. This will fail now:" + log.toString());
                continue;
            }
            log.append('\"').append(para);
            if (para.endsWith("\\")) {
                log.append('\\');
            }
            log.append("\" ");
        }
        this.task.getProject().getLogger().lifecycle(log.toString());
        DefaultExecAction action = new DefaultExecAction((PathToFileResolver)this.fileResolver, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        }, (BuildCancellationToken)new DefaultBuildCancellationToken());
        action.setCommandLine(parameters);
        action.setIgnoreExitValue(ignoreExitValue);
        action.setWorkingDir(this.buildDir);
        if (input != null) {
            action.setStandardInput(input);
        }
        if (output == null) {
            output = new IndentationOutputStream(System.out);
        }
        action.setStandardOutput(output);
        try {
            action.execute();
            output.flush();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    protected T getTask() {
        return this.task;
    }
}

