/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.appbundler;

import com.inet.gradle.setup.abstracts.AbstractBuilder;
import com.inet.gradle.setup.abstracts.AbstractSetupBuilder;
import com.inet.gradle.setup.abstracts.AbstractTask;
import java.io.File;
import java.util.ArrayList;
import org.gradle.api.internal.file.FileResolver;

public class OSXCodeSign<T extends AbstractTask, S extends AbstractSetupBuilder>
extends AbstractBuilder<T, S> {
    private String identity;
    private String identifier;
    private String keychain;
    private String keychainPassword;
    private boolean ignoreError;
    private boolean deepsign = true;

    public OSXCodeSign(T task, FileResolver fileResolver) {
        super(task, fileResolver);
    }

    public String getIdentity() {
        if (this.identity == null) {
            throw new IllegalArgumentException("You have to define the signing identity");
        }
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getKeychain() {
        return this.keychain;
    }

    public void setKeychain(String keychain) {
        this.keychain = keychain;
    }

    public String getKeychainPassword() {
        return this.keychainPassword;
    }

    public void setKeychainPassword(String keychainPassword) {
        this.keychainPassword = keychainPassword;
    }

    public boolean isIgnoreError() {
        return this.ignoreError;
    }

    public void setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
    }

    private void unlockKeychain() {
        if (this.getKeychainPassword() == null) {
            return;
        }
        String keychain = this.getKeychain() != null ? this.getKeychain() : System.getenv("HOME") + "/Library/Keychains/login.keychain";
        this.exec(this.isIgnoreError(), "security", "-v", "unlock-keychain", "-p", this.getKeychainPassword(), keychain);
    }

    public void signApplication(File path) {
        this.unlockKeychain();
        ArrayList<String> command = new ArrayList<String>();
        command.add("codesign");
        command.add("-f");
        if (this.isDeepsign()) {
            command.add("--deep");
        }
        command.add("-s");
        command.add(this.getIdentity());
        if (this.getIdentifier() != null) {
            command.add("-i");
            command.add(this.getIdentifier());
        }
        if (this.getKeychain() != null) {
            command.add("--keychain");
            command.add(this.getKeychain());
        }
        command.add(path.getAbsolutePath());
        this.exec(command, null, null, this.isIgnoreError());
    }

    public void signProduct(File path) {
        this.unlockKeychain();
        ArrayList<String> command = new ArrayList<String>();
        command.add("productsign");
        command.add("--sign");
        command.add(this.getIdentity());
        if (this.getKeychain() != null) {
            command.add("--keychain");
            command.add(this.getKeychain());
        }
        command.add(path.getAbsolutePath());
        File output = new File(path.getParentFile(), "signed." + path.getName());
        command.add(output.getAbsolutePath());
        this.exec(command, null, null, this.isIgnoreError());
        if (output.exists() && path.delete()) {
            output.renameTo(path);
        }
    }

    public boolean isDeepsign() {
        return this.deepsign;
    }

    public void setDeepsign(boolean deepsign) {
        this.deepsign = deepsign;
    }
}

