/*
 * Decompiled with CFR 0.152.
 */
package core.usecase;

import core.entity.BuildConfig;
import core.entity.BuildStatus;
import core.entity.ErrorMessage;
import core.entity.InfoMessage;
import core.entity.Message;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcore/usecase/PostStatusUseCase;", "", "sources", "", "Lcore/usecase/PostStatusUseCase$Datasource;", "config", "Lcore/entity/BuildConfig;", "messages", "", "Lcore/entity/Message;", "(Ljava/util/List;Lcore/entity/BuildConfig;Ljava/util/List;)V", "getConfig", "()Lcore/entity/BuildConfig;", "getSources", "()Ljava/util/List;", "validSources", "getValidSources", "validSources$delegate", "Lkotlin/Lazy;", "post", "", "status", "Lcore/entity/BuildStatus;", "message", "", "key", "removeInvalid", "Datasource", "BuildChecks"})
@SourceDebugExtension(value={"SMAP\nPostStatusUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostStatusUseCase.kt\ncore/usecase/PostStatusUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1849#2,2:51\n764#2:53\n855#2,2:54\n286#2,2:56\n764#2:58\n855#2,2:59\n764#2:61\n855#2,2:62\n*S KotlinDebug\n*F\n+ 1 PostStatusUseCase.kt\ncore/usecase/PostStatusUseCase\n*L\n14#1:51,2\n25#1:53\n25#1:54,2\n27#1:56,2\n32#1:58\n32#1:59,2\n37#1:61\n37#1:62,2\n*E\n"})
public class PostStatusUseCase {
    @NotNull
    private final List<Datasource> sources;
    @NotNull
    private final BuildConfig config;
    @NotNull
    private final List<Message> messages;
    @NotNull
    private final Lazy validSources$delegate;

    public PostStatusUseCase(@NotNull List<? extends Datasource> sources, @NotNull BuildConfig config, @NotNull List<Message> messages) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        this.sources = sources;
        this.config = config;
        this.messages = messages;
        this.validSources$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Datasource>>(this){
            final /* synthetic */ PostStatusUseCase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Datasource> invoke() {
                return this.this$0.removeInvalid();
            }
        }));
    }

    @NotNull
    public final List<Datasource> getSources() {
        return this.sources;
    }

    @NotNull
    public final BuildConfig getConfig() {
        return this.config;
    }

    private final List<Datasource> getValidSources() {
        Lazy lazy = this.validSources$delegate;
        return (List)lazy.getValue();
    }

    public void post(@NotNull BuildStatus status, @NotNull String message, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Iterable $this$forEach$iv = this.getValidSources();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Datasource source = (Datasource)element$iv;
            boolean bl = false;
            source.post(status, message, key).subscribe(arg_0 -> PostStatusUseCase.post$lambda$1$lambda$0((Function1)new Function1<Boolean, Unit>(source, this){
                final /* synthetic */ Datasource $source;
                final /* synthetic */ PostStatusUseCase this$0;
                {
                    this.$source = $source;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(Boolean isSuccess) {
                    if (!isSuccess.booleanValue()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        String string = this.$source.name();
                        if (string == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = string.toUpperCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
                        String error = stringBuilder.append(string2).append(" post failed, add -i for full logs").toString();
                        PostStatusUseCase.access$getMessages$p(this.this$0).add(new ErrorMessage(error));
                    }
                }
            }, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Datasource> removeInvalid() {
        Datasource it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.sources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Datasource)element$iv$iv;
            boolean bl = false;
            if (!it.isActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        if (this.config.isPostActivated()) {
            Object v0;
            block10: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Datasource it2 = (Datasource)element$iv;
                    boolean bl = false;
                    if (!it2.isRemote()) continue;
                    v0 = element$iv;
                    break block10;
                }
                v0 = null;
            }
            Datasource remote = v0;
            if (remote == null) {
                this.messages.add(new ErrorMessage("No recognized post config was found"));
            } else if (!this.config.isAllCommitted()) {
                void $this$filterTo$iv$iv2;
                this.messages.add(new ErrorMessage("You must commit all changes before posting checks to " + remote.name()));
                Iterable $this$filter$iv2 = list;
                boolean $i$f$filter2 = false;
                destination$iv$iv = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    Datasource it3 = (Datasource)element$iv$iv;
                    boolean bl = false;
                    if (!(!it3.isRemote())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                list = (List)destination$iv$iv2;
            } else {
                this.messages.add(new InfoMessage("Posting to " + remote.name()));
            }
        } else {
            $this$filter$iv = list;
            $i$f$filter = false;
            Iterable $i$f$filter2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Datasource)element$iv$iv;
                boolean bl = false;
                if (!(!it.isRemote())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final void post$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getMessages$p(PostStatusUseCase $this) {
        return $this.messages;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \r2\u00020\u0001:\u0001\rJ\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0006H&J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H&\u00a8\u0006\u000e"}, d2={"Lcore/usecase/PostStatusUseCase$Datasource;", "", "isActive", "", "isRemote", "name", "", "post", "Lio/reactivex/Observable;", "status", "Lcore/entity/BuildStatus;", "message", "key", "Companion", "BuildChecks"})
    public static interface Datasource {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public Observable<Boolean> post(@NotNull BuildStatus var1, @NotNull String var2, @NotNull String var3);

        @NotNull
        public String name();

        public boolean isActive();

        public boolean isRemote();

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcore/usecase/PostStatusUseCase$Datasource$Companion;", "", "()V", "BuildChecks"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }
}

