/*
 * Decompiled with CFR 0.152.
 */
package core.usecase;

import core.UtilsKt;
import core.entity.BuildConfig;
import core.entity.InfoMessage;
import core.entity.Log;
import core.entity.Message;
import core.usecase.BuildReport;
import core.usecase.BuildReportKt;
import core.usecase.DirectoryReport;
import core.usecase.HtmlReportKt;
import core.usecase.Link;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u001a \u0010\u0005\u001a\u00020\u00032\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u001a$\u0010\u0007\u001a\u00020\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\b\u001a\u00020\u0003\u001a\n\u0010\t\u001a\u00020\u0003*\u00020\n\u001a\n\u0010\t\u001a\u00020\u0003*\u00020\u000b\u001a\n\u0010\t\u001a\u00020\u0003*\u00020\f\u001a$\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0002\u0010\u0013\u001a\u00020\n\u00a8\u0006\u0014"}, d2={"csvToMapsList", "", "", "", "csv", "historyChart", "history", "jsArrayItemsFrom", "key", "toHtml", "Lcore/usecase/BuildReport;", "Lcore/usecase/DirectoryReport;", "Lcore/usecase/Link;", "writeBuildReports", "", "Lcore/entity/BuildConfig;", "messageQueue", "", "Lcore/entity/Message;", "buildReport", "BuildChecks"})
@SourceDebugExtension(value={"SMAP\nHtmlReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlReport.kt\ncore/usecase/HtmlReportKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1#2:197\n764#3:198\n855#3,2:199\n1547#3:201\n1618#3,2:202\n1849#3,2:204\n1620#3:206\n1043#3:207\n764#3:208\n855#3,2:209\n1547#3:211\n1618#3,3:212\n*S KotlinDebug\n*F\n+ 1 HtmlReport.kt\ncore/usecase/HtmlReportKt\n*L\n154#1:198\n154#1:199,2\n154#1:201\n154#1:202,2\n157#1:204,2\n154#1:206\n164#1:207\n168#1:208\n168#1:209,2\n194#1:211\n194#1:212,3\n*E\n"})
public final class HtmlReportKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toHtml(@NotNull BuildReport $this$toHtml) {
        List<Map<String, String>> list;
        StringBuilder stringBuilder;
        block3: {
            block2: {
                void it;
                List<Map<String, String>> list2;
                Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
                stringBuilder = new StringBuilder().append("\n<html>\n<meta charset=\"utf-8\">\n<style>body {font-family: Helvetica, Arial, sans-serif;line-height:160%;padding:20px} a:link{text-decoration:none}</style>\n<body>\n<h1>Build Summary</h1>\n").append(CollectionsKt.joinToString$default((Iterable)$this$toHtml.getMessages(), (CharSequence)"<br/>\n", null, null, (int)0, null, null, (int)62, null)).append('\n').append(CollectionsKt.joinToString$default((Iterable)$this$toHtml.getDirectoryReports(), (CharSequence)"", null, null, (int)0, null, (Function1)toHtml.1.INSTANCE, (int)30, null)).append('\n');
                list = $this$toHtml.getStatsHistory();
                if (list == null) break block2;
                List<Map<String, String>> list3 = list2 = list;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                String string = HtmlReportKt.historyChart((List<? extends Map<String, String>>)it);
                stringBuilder = stringBuilder2;
                list = string;
                if (string != null) break block3;
            }
            list = "";
        }
        return StringsKt.trimIndent((String)stringBuilder.append((String)((Object)list)).append("\n<p style=\"color:grey;font-size:11px\">\nGenerated using ").append($this$toHtml.getGitSummary()).append(" \nfrom ").append(CollectionsKt.joinToString$default((Iterable)$this$toHtml.getXmlLinks(), (CharSequence)", ", null, null, (int)0, null, (Function1)toHtml.3.INSTANCE, (int)30, null)).append("\n</p>\n</body>\n</html>\n").toString());
    }

    @NotNull
    public static final String historyChart(@NotNull List<? extends Map<String, String>> history) {
        Intrinsics.checkNotNullParameter(history, (String)"history");
        return StringsKt.trimIndent((String)("\n<script src=\"https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.13.0/moment.min.js\"></script>\n<script src=\"https://cdn.jsdelivr.net/npm/chart.js@2.8.0\"></script>\n<canvas id=\"myChart\" style=\"max-width:1000px\"></canvas>\n<script>\nvar timeFormat = 'MM/DD/YYYY HH:mm';\nfunction unixDate(stamp) {\n\treturn moment.unix(stamp).format(timeFormat);\n}\n\nvar coverageData = [" + HtmlReportKt.jsArrayItemsFrom(history, "coverage") + "];\nvar linePlusBranchData = [" + HtmlReportKt.jsArrayItemsFrom(history, "lines+branches") + "];\nvar durationData = [" + HtmlReportKt.jsArrayItemsFrom(history, "duration") + "];\nvar violationData = [" + HtmlReportKt.jsArrayItemsFrom(history, "violations") + "];\n\nwindow.chartColor = {\n\tred: 'rgb(255, 99, 132)',\n\tred2: 'rgb(255, 99, 132, 0.2)',\n\torange: 'rgb(255, 159, 64)',\n\torange2: 'rgb(255, 159, 64, 0.2)',\n\tyellow: 'rgb(255, 205, 86)',\n\tyellow2: 'rgb(255, 205, 86, 0.2)',\n\tgreen: 'rgb(75, 192, 192)',\n\tgreen2: 'rgb(75, 192, 192, 0.2)',\n\tblue: 'rgb(54, 162, 235)',\n\tblue2: 'rgb(54, 162, 235, 0.2)',\n\tpurple: 'rgb(153, 102, 255)',\n\tpurple2: 'rgb(153, 102, 255, 0.2)',\n\tgrey: 'rgb(201, 203, 207)',\n\tgrey2: 'rgb(201, 203, 207, 0.2)'\n};\n\nvar config = {\n    type: 'line',\n    data: {\n\t\tdatasets: [\n\t\t    {\n                label: 'Lines + Branches',\n                backgroundColor: window.chartColor.blue2,\n                borderColor: window.chartColor.blue,\n                borderWidth: 1,\n                fill: true,\n                yAxisID: 'y-axis-2',\n                data: linePlusBranchData,\n            },\n            {\n                label: 'Coverage %',\n                backgroundColor: window.chartColor.red2,\n                borderColor: window.chartColor.red,\n                borderWidth: 1,\n                fill: true,\n                yAxisID: 'y-axis-1',\n                data: coverageData,\n            },\n            {\n                label: 'Violations',\n                backgroundColor: window.chartColor.green2,\n                borderColor: window.chartColor.green,\n                borderWidth: 1,\n                fill: true,\n                yAxisID: 'y-axis-4',\n                data: violationData,\n                hidden: false,\n            },\n            {\n                label: 'Duration',\n                backgroundColor: window.chartColor.orange2,\n                borderColor: window.chartColor.orange,\n                borderWidth: 1,\n                fill: true,\n                yAxisID: 'y-axis-3',\n                data: durationData,\n                hidden: true,\n            },\n\t\t]\n\t},\n    options: {\n        responsive: true,\n        scales: {\n            xAxes: [{\n                type: 'time',\n                display: true,\n                time: {\n                    parser: timeFormat,\n                    tooltipFormat: 'll HH:mm'\n                },\n            }],\n            yAxes: [\n                {\n                    display: true,\n                    position: 'right',\n                    id: 'y-axis-1',\n                    ticks: {\n                        fontColor: window.chartColor.red\n                    }\n                },\n                {\n                    display: true,\n                    position: 'left',\n                    id: 'y-axis-2',\n                    ticks: {\n                        fontColor: window.chartColor.blue\n                    }\n                },\n                {\n                    display: true,\n                    position: 'right',\n                    id: 'y-axis-3',\n                    ticks: {\n                        fontColor: window.chartColor.orange\n                    }\n                },\n                {\n                    display: true,\n                    position: 'right',\n                    id: 'y-axis-4',\n                    ticks: {\n                        fontColor: window.chartColor.green\n                    }\n                }\n            ]\n        }\n    }\n}\n\nvar chart = new Chart(document.getElementById('myChart').getContext('2d'), config);\n</script>\n"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Map<String, String>> csvToMapsList(@Nullable String csv) {
        Object object;
        block8: {
            block7: {
                void $this$mapTo$iv$iv;
                void $this$filterTo$iv$iv;
                object = csv;
                if (object == null || (object = StringsKt.lines((CharSequence)((CharSequence)object))) == null) break block7;
                Iterable $this$filter$iv = (Iterable)object;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void row;
                    String bl = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    Map rowMap = new LinkedHashMap();
                    String[] stringArray = new String[]{","};
                    List cols = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)row, (String)"\"", (String)"", (boolean)false, (int)4, null), (String)", ", (String)",", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    Iterable $this$forEach$iv = cols;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String col = (String)element$iv;
                        boolean bl4 = false;
                        Object object2 = new String[]{"="};
                        Object it = object2 = StringsKt.split$default((CharSequence)col, (String[])object2, (boolean)false, (int)0, (int)6, null);
                        boolean bl5 = false;
                        if (it.size() == 2) {
                            rowMap.put(it.get(1), it.get(0));
                            continue;
                        }
                        rowMap.put("unknown", it.get(0));
                    }
                    collection.add(rowMap);
                }
                Iterable $this$sortedBy$iv = (List)destination$iv$iv2;
                boolean $i$f$sortedBy = false;
                object = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map it = (Map)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)it.get("date")));
                        it = (Map)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.get("date")))));
                    }
                });
                if (object != null) break block8;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String jsArrayItemsFrom(@NotNull List<? extends Map<String, String>> $this$jsArrayItemsFrom, @NotNull String key) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$jsArrayItemsFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Iterable $this$filter$iv = $this$jsArrayItemsFrom;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map it = (Map)element$iv$iv;
            boolean bl = false;
            if (!(it.get("date") != null && it.get(key) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, (Function1)((Function1)new Function1<Map<String, ? extends String>, CharSequence>(key){
            final /* synthetic */ String $key;
            {
                this.$key = $key;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Map<String, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return "{ x:unixDate(\"" + it.get("date") + "\"), y:" + it.get(this.$key) + " }";
            }
        }), (int)30, null);
    }

    public static final void writeBuildReports(@NotNull BuildConfig $this$writeBuildReports, @NotNull List<Message> messageQueue, @NotNull BuildReport buildReport) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$writeBuildReports, (String)"<this>");
        Intrinsics.checkNotNullParameter(messageQueue, (String)"messageQueue");
        Intrinsics.checkNotNullParameter((Object)buildReport, (String)"buildReport");
        File $this$writeBuildReports_u24lambda_u247 = file = $this$writeBuildReports.buildReportFile();
        boolean bl = false;
        $this$writeBuildReports_u24lambda_u247.getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$writeBuildReports_u24lambda_u247, (String)HtmlReportKt.toHtml(buildReport), null, (int)2, null);
        messageQueue.add(new InfoMessage("Browse reports at " + $this$writeBuildReports_u24lambda_u247.getAbsoluteFile().toURI()));
        if ($this$writeBuildReports.isOpenActivated()) {
            Log log = $this$writeBuildReports.getLog();
            if (log != null) {
                log.info("Opening " + $this$writeBuildReports_u24lambda_u247.getAbsoluteFile().toURI());
            }
            UtilsKt.run("open " + $this$writeBuildReports_u24lambda_u247.getAbsoluteFile().toURI());
        }
        File $this$writeBuildReports_u24lambda_u248 = file = new File($this$writeBuildReports.artifactsDir(), "stats.csv");
        boolean bl2 = false;
        FilesKt.writeText$default((File)$this$writeBuildReports_u24lambda_u248, (String)buildReport.getStats().toString(), null, (int)2, null);
    }

    public static /* synthetic */ void writeBuildReports$default(BuildConfig buildConfig, List list, BuildReport buildReport, int n, Object object) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        if ((n & 2) != 0) {
            buildReport = BuildReportKt.toBuildReport(buildConfig);
        }
        HtmlReportKt.writeBuildReports(buildConfig, list, buildReport);
    }

    @NotNull
    public static final String toHtml(@NotNull Link $this$toHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
        return "<a href=\"" + $this$toHtml.getFile().getPath() + "\">" + $this$toHtml.getName() + "</a>";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toHtml(@NotNull DirectoryReport $this$toHtml) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
        Iterable iterable = $this$toHtml.getMessages();
        StringBuilder stringBuilder = new StringBuilder().append("\n    <h3>").append($this$toHtml.getDirectoryLink().getName()).append("</h3>       \n    <ul style=\"list-style: none;\">        \n        ").append(CollectionsKt.joinToString$default((Iterable)$this$toHtml.getReadableLinks(), (CharSequence)"\n", null, null, (int)0, null, (Function1)toHtml.4.INSTANCE, (int)30, null)).append("\n        ");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Message message = (Message)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            collection.add(v0 != null ? v0.getString() : null);
        }
        return StringsKt.trimIndent((String)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)toHtml.6.INSTANCE, (int)30, null)).append("\n    </ul>\n").toString());
    }
}

