/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.AuthParameters;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public class TargetImageParameters {
    private final AuthParameters auth;
    private Property<String> image;
    private SetProperty<String> tags;
    @Nullable
    private String credHelper;

    @Inject
    public TargetImageParameters(ObjectFactory objectFactory) {
        this.auth = (AuthParameters)objectFactory.newInstance(AuthParameters.class, new Object[]{"to.auth"});
        this.image = objectFactory.property(String.class);
        this.tags = objectFactory.setProperty(String.class).empty();
    }

    @Input
    @Nullable
    @Optional
    public String getImage() {
        if (System.getProperty("jib.to.image") != null) {
            return System.getProperty("jib.to.image");
        }
        return (String)this.image.getOrNull();
    }

    public void setImage(String image) {
        this.image.set((Object)image);
    }

    public void setImage(Provider<String> image) {
        this.image.set(image);
    }

    @Input
    @Optional
    public Set<String> getTags() {
        Object tagsValue;
        String property = System.getProperty("jib.to.tags");
        if (property != null) {
            tagsValue = ImmutableSet.copyOf(ConfigurationPropertyValidator.parseListProperty(property));
        } else {
            try {
                tagsValue = (Set)this.tags.get();
            }
            catch (NullPointerException ex) {
                throw new IllegalArgumentException("jib.to.tags contains null tag");
            }
        }
        if (tagsValue.stream().anyMatch(str -> str.isEmpty())) {
            throw new IllegalArgumentException("jib.to.tags contains empty tag");
        }
        return tagsValue;
    }

    public void setTags(List<String> tags) {
        this.tags.set(tags);
    }

    public void setTags(Set<String> tags) {
        this.tags.set(tags);
    }

    public void setTags(Provider<Set<String>> tags) {
        this.tags.set(tags);
    }

    @Input
    @Nullable
    @Optional
    public String getCredHelper() {
        if (System.getProperty("jib.to.credHelper") != null) {
            return System.getProperty("jib.to.credHelper");
        }
        return this.credHelper;
    }

    public void setCredHelper(String credHelper) {
        this.credHelper = credHelper;
    }

    @Nested
    @Optional
    public AuthParameters getAuth() {
        return this.auth;
    }

    public void auth(Action<? super AuthParameters> action) {
        action.execute((Object)this.auth);
    }
}

