/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.ExtraDirectoryParameters;
import com.google.cloud.tools.jib.gradle.ExtraDirectoryParametersSpec;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;

public class ExtraDirectoriesParameters {
    private final ObjectFactory objects;
    private final Project project;
    private ListProperty<ExtraDirectoryParameters> paths;
    private ExtraDirectoryParametersSpec spec;
    private Map<String, String> permissions = Collections.emptyMap();

    @Inject
    public ExtraDirectoriesParameters(ObjectFactory objects, Project project) {
        this.objects = objects;
        this.project = project;
        this.paths = objects.listProperty(ExtraDirectoryParameters.class).empty();
        this.spec = (ExtraDirectoryParametersSpec)objects.newInstance(ExtraDirectoryParametersSpec.class, new Object[]{project, this.paths});
    }

    public void paths(Action<? super ExtraDirectoryParametersSpec> action) {
        action.execute((Object)this.spec);
    }

    @Input
    public List<String> getPathStrings() {
        return this.getPaths().stream().map(extraDirectoryParameters -> extraDirectoryParameters.getFrom().toString()).collect(Collectors.toList());
    }

    @Internal
    public List<ExtraDirectoryParameters> getPaths() {
        String property = System.getProperty("jib.extraDirectories.paths");
        if (property != null) {
            List<String> pathStrings = ConfigurationPropertyValidator.parseListProperty(property);
            return pathStrings.stream().map(path -> new ExtraDirectoryParameters(this.objects, this.project, Paths.get(path, new String[0]), "/")).collect(Collectors.toList());
        }
        if (((List)this.paths.get()).isEmpty()) {
            return Collections.singletonList(new ExtraDirectoryParameters(this.objects, this.project, this.project.getProjectDir().toPath().resolve("src").resolve("main").resolve("jib"), "/"));
        }
        return (List)this.paths.get();
    }

    public void setPaths(Object paths) {
        this.paths.set((Iterable)this.project.files(new Object[]{paths}).getFiles().stream().map(file -> new ExtraDirectoryParameters(this.objects, this.project, file.toPath(), "/")).collect(Collectors.toList()));
    }

    @Input
    public Map<String, String> getPermissions() {
        String property = System.getProperty("jib.extraDirectories.permissions");
        if (property != null) {
            return ConfigurationPropertyValidator.parseMapProperty(property);
        }
        return this.permissions;
    }

    public void setPermissions(Map<String, String> permissions) {
        this.permissions = permissions;
    }
}

