/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.event;

import com.google.cloud.tools.jib.api.JibEvent;
import com.google.common.base.Preconditions;
import java.util.function.Consumer;

class Handler<E extends JibEvent> {
    private final Class<E> eventClass;
    private final Consumer<? super E> eventConsumer;

    Handler(Class<E> eventClass, Consumer<? super E> eventConsumer) {
        this.eventClass = eventClass;
        this.eventConsumer = eventConsumer;
    }

    void handle(JibEvent jibEvent) {
        Preconditions.checkArgument((boolean)this.eventClass.isInstance(jibEvent));
        this.eventConsumer.accept(this.eventClass.cast(jibEvent));
    }
}

