/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common.logging;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class SingleThreadedExecutor {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public void shutDownAndAwaitTermination(Duration timeout) {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(timeout.getSeconds(), TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(timeout.getSeconds(), TimeUnit.SECONDS)) {
                    System.err.println("Could not shut down SingleThreadedExecutor");
                }
            }
        }
        catch (InterruptedException ex) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void execute(Runnable runnable) {
        this.executorService.execute(runnable);
    }
}

