/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.BaseImageParameters;
import com.google.cloud.tools.jib.gradle.ContainerParameters;
import com.google.cloud.tools.jib.gradle.DockerClientParameters;
import com.google.cloud.tools.jib.gradle.ExtensionParameters;
import com.google.cloud.tools.jib.gradle.ExtensionParametersSpec;
import com.google.cloud.tools.jib.gradle.ExtraDirectoriesParameters;
import com.google.cloud.tools.jib.gradle.OutputPathsParameters;
import com.google.cloud.tools.jib.gradle.TargetImageParameters;
import com.google.cloud.tools.jib.gradle.skaffold.SkaffoldParameters;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public class JibExtension {
    private static final boolean DEFAULT_ALLOW_INSECURE_REGISTIRIES = false;
    private static final String DEFAULT_CONTAINERIZING_MODE = "exploded";
    private final BaseImageParameters from;
    private final TargetImageParameters to;
    private final ContainerParameters container;
    private final ExtraDirectoriesParameters extraDirectories;
    private final DockerClientParameters dockerClient;
    private final OutputPathsParameters outputPaths;
    private final SkaffoldParameters skaffold;
    private final Property<Boolean> allowInsecureRegistries;
    private final Property<String> containerizingMode;
    private final ListProperty<ExtensionParameters> pluginExtensions;
    private final ExtensionParametersSpec extensionParametersSpec;

    public JibExtension(Project project) {
        ObjectFactory objectFactory = project.getObjects();
        this.from = (BaseImageParameters)objectFactory.newInstance(BaseImageParameters.class, new Object[0]);
        this.to = (TargetImageParameters)objectFactory.newInstance(TargetImageParameters.class, new Object[0]);
        this.container = (ContainerParameters)objectFactory.newInstance(ContainerParameters.class, new Object[0]);
        this.extraDirectories = (ExtraDirectoriesParameters)objectFactory.newInstance(ExtraDirectoriesParameters.class, new Object[]{project});
        this.dockerClient = (DockerClientParameters)objectFactory.newInstance(DockerClientParameters.class, new Object[0]);
        this.outputPaths = (OutputPathsParameters)objectFactory.newInstance(OutputPathsParameters.class, new Object[]{project});
        this.skaffold = (SkaffoldParameters)objectFactory.newInstance(SkaffoldParameters.class, new Object[]{project});
        this.pluginExtensions = objectFactory.listProperty(ExtensionParameters.class).empty();
        this.extensionParametersSpec = (ExtensionParametersSpec)objectFactory.newInstance(ExtensionParametersSpec.class, new Object[]{this.pluginExtensions});
        this.allowInsecureRegistries = objectFactory.property(Boolean.class);
        this.containerizingMode = objectFactory.property(String.class);
        this.allowInsecureRegistries.set((Object)false);
        this.containerizingMode.set((Object)DEFAULT_CONTAINERIZING_MODE);
    }

    public void from(Action<? super BaseImageParameters> action) {
        action.execute((Object)this.from);
    }

    public void to(Action<? super TargetImageParameters> action) {
        action.execute((Object)this.to);
    }

    public void container(Action<? super ContainerParameters> action) {
        action.execute((Object)this.container);
    }

    public void extraDirectories(Action<? super ExtraDirectoriesParameters> action) {
        action.execute((Object)this.extraDirectories);
    }

    public void dockerClient(Action<? super DockerClientParameters> action) {
        action.execute((Object)this.dockerClient);
    }

    public void outputPaths(Action<? super OutputPathsParameters> action) {
        action.execute((Object)this.outputPaths);
    }

    public void skaffold(Action<? super SkaffoldParameters> action) {
        action.execute((Object)this.skaffold);
    }

    public void pluginExtensions(Action<? super ExtensionParametersSpec> action) {
        action.execute((Object)this.extensionParametersSpec);
    }

    public void setAllowInsecureRegistries(boolean allowInsecureRegistries) {
        this.allowInsecureRegistries.set((Object)allowInsecureRegistries);
    }

    public void setContainerizingMode(String containerizingMode) {
        this.containerizingMode.set((Object)containerizingMode);
    }

    @Nested
    @Optional
    public BaseImageParameters getFrom() {
        return this.from;
    }

    @Nested
    @Optional
    public TargetImageParameters getTo() {
        return this.to;
    }

    @Nested
    @Optional
    public ContainerParameters getContainer() {
        return this.container;
    }

    @Nested
    @Optional
    public ExtraDirectoriesParameters getExtraDirectories() {
        return this.extraDirectories;
    }

    @Nested
    @Optional
    public DockerClientParameters getDockerClient() {
        return this.dockerClient;
    }

    @Nested
    @Optional
    public OutputPathsParameters getOutputPaths() {
        return this.outputPaths;
    }

    @Nested
    @Optional
    public SkaffoldParameters getSkaffold() {
        return this.skaffold;
    }

    @Input
    boolean getAllowInsecureRegistries() {
        if (System.getProperty("jib.allowInsecureRegistries") != null) {
            return Boolean.getBoolean("jib.allowInsecureRegistries");
        }
        return (Boolean)this.allowInsecureRegistries.get();
    }

    @Input
    @Optional
    public String getContainerizingMode() {
        String property = System.getProperty("jib.containerizingMode");
        return property != null ? property : (String)this.containerizingMode.get();
    }

    @Nested
    @Optional
    public ListProperty<ExtensionParameters> getPluginExtensions() {
        return this.pluginExtensions;
    }
}

