/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.ProjectInfo;
import com.google.cloud.tools.jib.gradle.BuildDockerTask;
import com.google.cloud.tools.jib.gradle.BuildImageTask;
import com.google.cloud.tools.jib.gradle.BuildTarTask;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.TaskCommon;
import com.google.cloud.tools.jib.gradle.skaffold.CheckJibVersionTask;
import com.google.cloud.tools.jib.gradle.skaffold.FilesTask;
import com.google.cloud.tools.jib.gradle.skaffold.FilesTaskV2;
import com.google.cloud.tools.jib.gradle.skaffold.InitTask;
import com.google.cloud.tools.jib.gradle.skaffold.SyncMapTask;
import com.google.cloud.tools.jib.plugins.common.VersionChecker;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;

public class JibPlugin
implements Plugin<Project> {
    @VisibleForTesting
    static final GradleVersion GRADLE_MIN_VERSION = GradleVersion.version((String)"4.9");
    public static final String JIB_EXTENSION_NAME = "jib";
    public static final String BUILD_IMAGE_TASK_NAME = "jib";
    public static final String BUILD_TAR_TASK_NAME = "jibBuildTar";
    public static final String BUILD_DOCKER_TASK_NAME = "jibDockerBuild";
    public static final String SKAFFOLD_FILES_TASK_NAME = "_jibSkaffoldFiles";
    public static final String SKAFFOLD_FILES_TASK_V2_NAME = "_jibSkaffoldFilesV2";
    public static final String SKAFFOLD_INIT_TASK_NAME = "_jibSkaffoldInit";
    public static final String SKAFFOLD_SYNC_MAP_TASK_NAME = "_jibSkaffoldSyncMap";
    public static final String SKAFFOLD_CHECK_REQUIRED_VERSION_TASK_NAME = "_skaffoldFailIfJibOutOfDate";
    public static final String REQUIRED_VERSION_PROPERTY_NAME = "jib.requiredVersion";

    @VisibleForTesting
    static List<Project> getProjectDependencies(Project project) {
        return project.getConfigurations().stream().map(Configuration::getDependencies).flatMap(Collection::stream).filter(ProjectDependency.class::isInstance).map(ProjectDependency.class::cast).map(ProjectDependency::getDependencyProject).collect(Collectors.toList());
    }

    private static void checkGradleVersion() {
        if (GRADLE_MIN_VERSION.compareTo(GradleVersion.current()) > 0) {
            throw new GradleException("Detected " + GradleVersion.current() + ", but jib requires " + GRADLE_MIN_VERSION + " or higher. You can upgrade by running 'gradle wrapper --gradle-version=" + GRADLE_MIN_VERSION.getVersion() + "'.");
        }
    }

    private static void checkJibVersion() {
        String requiredVersion = System.getProperty(REQUIRED_VERSION_PROPERTY_NAME);
        if (requiredVersion == null) {
            return;
        }
        String actualVersion = ProjectInfo.VERSION;
        if (actualVersion == null) {
            throw new GradleException("Could not determine Jib plugin version");
        }
        VersionChecker<GradleVersion> checker = new VersionChecker<GradleVersion>(GradleVersion::version);
        if (!checker.compatibleVersion(requiredVersion, actualVersion)) {
            String failure = String.format("Jib plugin version is %s but is required to be %s", actualVersion, requiredVersion);
            throw new GradleException(failure);
        }
    }

    public void apply(Project project) {
        JibPlugin.checkGradleVersion();
        JibPlugin.checkJibVersion();
        JibExtension jibExtension = (JibExtension)project.getExtensions().create("jib", JibExtension.class, new Object[]{project});
        TaskContainer tasks = project.getTasks();
        TaskProvider buildImageTask = tasks.register("jib", BuildImageTask.class, task -> {
            task.setGroup("Jib");
            task.setDescription("Builds a container image to a registry.");
            task.setJibExtension(jibExtension);
        });
        TaskProvider buildDockerTask = tasks.register(BUILD_DOCKER_TASK_NAME, BuildDockerTask.class, task -> {
            task.setGroup("Jib");
            task.setDescription("Builds a container image to a Docker daemon.");
            task.setJibExtension(jibExtension);
        });
        TaskProvider buildTarTask = tasks.register(BUILD_TAR_TASK_NAME, BuildTarTask.class, task -> {
            task.setGroup("Jib");
            task.setDescription("Builds a container image to a tarball.");
            task.setJibExtension(jibExtension);
        });
        tasks.register(SKAFFOLD_FILES_TASK_NAME, FilesTask.class).configure(task -> task.setJibExtension(jibExtension));
        tasks.register(SKAFFOLD_FILES_TASK_V2_NAME, FilesTaskV2.class).configure(task -> task.setJibExtension(jibExtension));
        tasks.register(SKAFFOLD_INIT_TASK_NAME, InitTask.class).configure(task -> task.setJibExtension(jibExtension));
        TaskProvider syncMapTask = tasks.register(SKAFFOLD_SYNC_MAP_TASK_NAME, SyncMapTask.class, task -> task.setJibExtension(jibExtension));
        tasks.register(SKAFFOLD_CHECK_REQUIRED_VERSION_TASK_NAME, CheckJibVersionTask.class);
        project.afterEvaluate(projectAfterEvaluation -> {
            try {
                TaskProvider<Task> warTask = TaskCommon.getWarTaskProvider(project);
                TaskProvider<Task> bootWarTask = TaskCommon.getBootWarTaskProvider(project);
                ArrayList<Object> dependsOnTask = new ArrayList<Object>();
                if (warTask != null || bootWarTask != null) {
                    if (warTask != null) {
                        dependsOnTask.add(warTask);
                    }
                    if (bootWarTask != null) {
                        dependsOnTask.add(bootWarTask);
                    }
                } else if ("packaged".equals(jibExtension.getContainerizingMode())) {
                    dependsOnTask.add(projectAfterEvaluation.getTasks().named("jar"));
                } else {
                    dependsOnTask.add(projectAfterEvaluation.getTasks().named("classes"));
                }
                buildImageTask.configure(task -> task.dependsOn(new Object[]{dependsOnTask}));
                buildDockerTask.configure(task -> task.dependsOn(new Object[]{dependsOnTask}));
                buildTarTask.configure(task -> task.dependsOn(new Object[]{dependsOnTask}));
                syncMapTask.configure(task -> task.dependsOn(new Object[]{dependsOnTask}));
                List<Project> computedDependencies = JibPlugin.getProjectDependencies(projectAfterEvaluation);
                for (Project dependencyProject : computedDependencies) {
                    dependencyProject.getPlugins().withType(BasePlugin.class, unused -> {
                        TaskProvider assembleTask = dependencyProject.getTasks().named("assemble");
                        buildImageTask.configure(task -> task.dependsOn(new Object[]{assembleTask}));
                        buildDockerTask.configure(task -> task.dependsOn(new Object[]{assembleTask}));
                        buildTarTask.configure(task -> task.dependsOn(new Object[]{assembleTask}));
                    });
                }
            }
            catch (UnknownTaskException ex) {
                throw new GradleException("Could not find task 'classes' on project " + projectAfterEvaluation.getDisplayName() + " - perhaps you did not apply the 'java' plugin?", (Throwable)ex);
            }
        });
    }
}

