/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.gradle.DockerClientParameters;
import com.google.cloud.tools.jib.gradle.GradleHelpfulSuggestions;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.GradleRawConfiguration;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.JibTask;
import com.google.cloud.tools.jib.gradle.TaskCommon;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.IncompatibleBaseImageJavaVersionException;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerVolumeException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerizingModeException;
import com.google.cloud.tools.jib.plugins.common.InvalidCreationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidFilesModificationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidWorkingDirectoryException;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class BuildDockerTask
extends DefaultTask
implements JibTask {
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Build to Docker daemon failed";
    @Nullable
    private JibExtension jibExtension;
    private final DockerClientParameters dockerClientParameters = new DockerClientParameters();

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @Option(option="image", description="The image reference for the target image")
    public void setTargetImage(String targetImage) {
        ((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getTo().setImage(targetImage);
    }

    @Nested
    @Optional
    @Deprecated
    public DockerClientParameters getDockerClient() {
        return this.dockerClientParameters;
    }

    @Deprecated
    public void dockerClient(Action<? super DockerClientParameters> action) {
        action.execute((Object)this.dockerClientParameters);
    }

    @TaskAction
    public void buildDocker() throws IOException, BuildStepsExecutionException, CacheDirectoryCreationException, MainClassInferenceException {
        boolean isDockerInstalled;
        Preconditions.checkNotNull((Object)this.jibExtension);
        Path dockerExecutable = this.jibExtension.getDockerClient().getExecutablePath();
        Map<String, String> dockerEnvironment = this.jibExtension.getDockerClient().getEnvironment();
        if (this.getDockerClient().getExecutable() != null) {
            this.jibExtension.getDockerClient().setExecutable(this.getDockerClient().getExecutable());
            this.getProject().getLogger().warn("'jibDockerBuild.dockerClient.executable' is deprecated; use 'jib.dockerClient.executable' instead.");
        }
        if (!this.getDockerClient().getEnvironment().isEmpty()) {
            this.jibExtension.getDockerClient().setEnvironment(this.getDockerClient().getEnvironment());
            this.getProject().getLogger().warn("'jibDockerBuild.dockerClient.environment' is deprecated; use 'jib.dockerClient.environment' instead.");
        }
        if (this.getDockerClient().getExecutable() != null && dockerExecutable != null || !this.getDockerClient().getEnvironment().isEmpty() && !dockerEnvironment.isEmpty()) {
            throw new GradleException("Cannot configure 'jibDockerBuild.dockerClient' and 'jib.dockerClient' simultaneously");
        }
        boolean bl = isDockerInstalled = dockerExecutable == null ? DockerClient.isDefaultDockerInstalled() : DockerClient.isDockerInstalled(dockerExecutable);
        if (!isDockerInstalled) {
            throw new GradleException(HelpfulSuggestions.forDockerNotInstalled(HELPFUL_SUGGESTIONS_PREFIX));
        }
        TaskCommon.checkDeprecatedUsage(this.jibExtension, this.getLogger());
        TaskCommon.disableHttpLogging();
        TempDirectoryProvider tempDirectoryProvider = new TempDirectoryProvider();
        GradleProjectProperties projectProperties = GradleProjectProperties.getForProject(this.getProject(), this.getLogger(), tempDirectoryProvider);
        try {
            PluginConfigurationProcessor.createJibBuildRunnerForDockerDaemonImage(new GradleRawConfiguration(this.jibExtension), ignored -> java.util.Optional.empty(), projectProperties, new GradleHelpfulSuggestions(HELPFUL_SUGGESTIONS_PREFIX)).runBuild();
        }
        catch (InvalidAppRootException ex) {
            throw new GradleException("container.appRoot is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Throwable)ex);
        }
        catch (InvalidContainerizingModeException ex) {
            throw new GradleException("invalid value for containerizingMode: " + ex.getInvalidContainerizingMode(), (Throwable)ex);
        }
        catch (InvalidWorkingDirectoryException ex) {
            throw new GradleException("container.workingDirectory is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Throwable)ex);
        }
        catch (InvalidContainerVolumeException ex) {
            throw new GradleException("container.volumes is not an absolute Unix-style path: " + ex.getInvalidVolume(), (Throwable)ex);
        }
        catch (InvalidFilesModificationTimeException ex) {
            throw new GradleException("container.filesModificationTime should be an ISO 8601 date-time (see DateTimeFormatter.ISO_DATE_TIME) or special keyword \"EPOCH_PLUS_SECOND\": " + ex.getInvalidFilesModificationTime(), (Throwable)ex);
        }
        catch (InvalidCreationTimeException ex) {
            throw new GradleException("container.creationTime should be an ISO 8601 date-time (see DateTimeFormatter.ISO_DATE_TIME) or a special keyword (\"EPOCH\", \"USE_CURRENT_TIMESTAMP\"): " + ex.getInvalidCreationTime(), (Throwable)ex);
        }
        catch (IncompatibleBaseImageJavaVersionException ex) {
            throw new GradleException(HelpfulSuggestions.forIncompatibleBaseImageJavaVersionForGradle(ex.getBaseImageMajorJavaVersion(), ex.getProjectMajorJavaVersion()), (Throwable)ex);
        }
        catch (InvalidImageReferenceException ex) {
            throw new GradleException(HelpfulSuggestions.forInvalidImageReference(ex.getInvalidReference()), (Throwable)ex);
        }
        finally {
            tempDirectoryProvider.close();
            projectProperties.waitForLoggingThread();
        }
    }

    @Override
    public BuildDockerTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }
}

