/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class AuthenticatePushStep
implements Callable<Optional<Authorization>> {
    private static final String DESCRIPTION = "Authenticating push to %s";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    @Nullable
    private final Credential registryCredential;

    AuthenticatePushStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, @Nullable Credential registryCredential) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.registryCredential = registryCredential;
    }

    @Override
    public Optional<Authorization> call() throws IOException, RegistryException {
        String registry = this.buildContext.getTargetImageConfiguration().getImageRegistry();
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("authenticating push to " + registry, 1L);
             TimerEventDispatcher ignored2 = new TimerEventDispatcher(this.buildContext.getEventHandlers(), String.format(DESCRIPTION, registry));){
            Optional<RegistryAuthenticator> registryAuthenticator = this.buildContext.newTargetImageRegistryClientFactory().newRegistryClient().getRegistryAuthenticator();
            if (registryAuthenticator.isPresent()) {
                Optional<Authorization> optional = Optional.of(registryAuthenticator.get().authenticatePush(this.registryCredential));
                return optional;
            }
        }
        return this.registryCredential == null || this.registryCredential.isOAuth2RefreshToken() ? Optional.empty() : Optional.of(Authorization.fromBasicCredentials(this.registryCredential.getUsername(), this.registryCredential.getPassword()));
    }
}

