/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.plugins.common.SkaffoldFilesOutput;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

public class FilesTaskV2
extends DefaultTask {
    private final SkaffoldFilesOutput skaffoldFilesOutput = new SkaffoldFilesOutput();
    @Nullable
    private JibExtension jibExtension;

    public FilesTaskV2 setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }

    @TaskAction
    public void listFiles() throws IOException {
        Preconditions.checkNotNull((Object)this.jibExtension);
        Project project = this.getProject();
        if (project != project.getRootProject()) {
            this.addGradleFiles(project.getRootProject());
        }
        this.addProjectFiles(project);
        List<Path> extraDirectories = this.jibExtension.getExtraDirectories().getPaths();
        extraDirectories.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(this.skaffoldFilesOutput::addInput);
        Set<ProjectDependency> projectDependencies = this.findProjectDependencies(project);
        HashSet<File> projectDependencyJars = new HashSet<File>();
        for (ProjectDependency projectDependency : projectDependencies) {
            this.addProjectFiles(projectDependency.getDependencyProject());
            String configurationName = projectDependency.getTargetConfiguration();
            if (configurationName == null) {
                configurationName = "default";
            }
            Project dependencyProject = projectDependency.getDependencyProject();
            for (Configuration targetConfiguration : dependencyProject.getConfigurations().getByName(configurationName).getHierarchy()) {
                for (PublishArtifact artifact : targetConfiguration.getArtifacts()) {
                    projectDependencyJars.add(artifact.getFile());
                }
            }
        }
        for (File file : project.getConfigurations().getByName("runtime")) {
            if (projectDependencyJars.contains(file) || !file.toString().contains("SNAPSHOT")) continue;
            this.skaffoldFilesOutput.addInput(file.toPath());
            projectDependencyJars.add(file);
        }
        System.out.println("\nBEGIN JIB JSON");
        System.out.println(this.skaffoldFilesOutput.getJsonString());
    }

    private void addGradleFiles(Project project) {
        Path projectPath = project.getProjectDir().toPath();
        this.skaffoldFilesOutput.addBuild(project.getBuildFile().toPath());
        if (project.getGradle().getStartParameter().getSettingsFile() != null) {
            this.skaffoldFilesOutput.addBuild(project.getGradle().getStartParameter().getSettingsFile().toPath());
        } else if (Files.exists(projectPath.resolve("settings.gradle"), new LinkOption[0])) {
            this.skaffoldFilesOutput.addBuild(projectPath.resolve("settings.gradle"));
        }
        if (Files.exists(projectPath.resolve("gradle.properties"), new LinkOption[0])) {
            this.skaffoldFilesOutput.addBuild(projectPath.resolve("gradle.properties"));
        }
    }

    private void addProjectFiles(Project project) {
        this.addGradleFiles(project);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().findByName("main");
        if (mainSourceSet != null) {
            mainSourceSet.getAllSource().getSourceDirectories().forEach(sourceDirectory -> {
                if (sourceDirectory.exists()) {
                    this.skaffoldFilesOutput.addInput(sourceDirectory.toPath());
                }
            });
        }
    }

    private Set<ProjectDependency> findProjectDependencies(Project project) {
        HashSet<ProjectDependency> projectDependencies = new HashSet<ProjectDependency>();
        ArrayDeque<Project> projects = new ArrayDeque<Project>();
        projects.push(project);
        while (!projects.isEmpty()) {
            Project currentProject = (Project)projects.pop();
            for (Configuration configuration : currentProject.getConfigurations().getByName("runtime").getHierarchy()) {
                for (Dependency dependency : configuration.getDependencies()) {
                    ProjectDependency projectDependency;
                    if (!(dependency instanceof ProjectDependency) || projectDependencies.contains(projectDependency = (ProjectDependency)dependency)) continue;
                    projects.push(projectDependency.getDependencyProject());
                    projectDependencies.add(projectDependency);
                }
            }
        }
        return projectDependencies;
    }
}

