/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.api.ImageFormat;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class ContainerParameters {
    private boolean useCurrentTimestamp = false;
    private List<String> jvmFlags = Collections.emptyList();
    private Map<String, String> environment = Collections.emptyMap();
    @Nullable
    private List<String> entrypoint;
    private List<String> extraClasspath = Collections.emptyList();
    @Nullable
    private String mainClass;
    @Nullable
    private List<String> args;
    private ImageFormat format = ImageFormat.Docker;
    private List<String> ports = Collections.emptyList();
    private List<String> volumes = Collections.emptyList();
    private Map<String, String> labels = Collections.emptyMap();
    private String appRoot = "";
    @Nullable
    private String user;
    @Nullable
    private String workingDirectory;

    @Input
    @Optional
    public boolean getUseCurrentTimestamp() {
        if (System.getProperty("jib.container.useCurrentTimestamp") != null) {
            return Boolean.getBoolean("jib.container.useCurrentTimestamp");
        }
        return this.useCurrentTimestamp;
    }

    public void setUseCurrentTimestamp(boolean useCurrentTimestamp) {
        this.useCurrentTimestamp = useCurrentTimestamp;
    }

    @Input
    @Nullable
    @Optional
    public List<String> getEntrypoint() {
        if (System.getProperty("jib.container.entrypoint") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.entrypoint"));
        }
        return this.entrypoint;
    }

    public void setEntrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
    }

    public void setEntrypoint(String entrypoint) {
        this.entrypoint = Collections.singletonList(entrypoint);
    }

    @Input
    @Optional
    public List<String> getJvmFlags() {
        if (System.getProperty("jib.container.jvmFlags") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.jvmFlags"));
        }
        return this.jvmFlags;
    }

    public void setJvmFlags(List<String> jvmFlags) {
        this.jvmFlags = jvmFlags;
    }

    @Input
    @Optional
    public Map<String, String> getEnvironment() {
        if (System.getProperty("jib.container.environment") != null) {
            return ConfigurationPropertyValidator.parseMapProperty(System.getProperty("jib.container.environment"));
        }
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    @Input
    @Optional
    public List<String> getExtraClasspath() {
        if (System.getProperty("jib.container.extraClasspath") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.extraClasspath"));
        }
        return this.extraClasspath;
    }

    public void setExtraClasspath(List<String> classpath) {
        this.extraClasspath = classpath;
    }

    @Input
    @Nullable
    @Optional
    public String getMainClass() {
        if (System.getProperty("jib.container.mainClass") != null) {
            return System.getProperty("jib.container.mainClass");
        }
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @Input
    @Nullable
    @Optional
    public List<String> getArgs() {
        if (System.getProperty("jib.container.args") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.args"));
        }
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    @Input
    @Optional
    public ImageFormat getFormat() {
        if (System.getProperty("jib.container.format") != null) {
            return ImageFormat.valueOf(System.getProperty("jib.container.format"));
        }
        return (ImageFormat)((Object)Preconditions.checkNotNull((Object)((Object)this.format)));
    }

    public void setFormat(ImageFormat format) {
        this.format = format;
    }

    @Input
    @Optional
    public List<String> getPorts() {
        if (System.getProperty("jib.container.ports") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.ports"));
        }
        return this.ports;
    }

    public void setPorts(List<String> ports) {
        this.ports = ports;
    }

    @Input
    @Optional
    public List<String> getVolumes() {
        if (System.getProperty("jib.container.volumes") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.volumes"));
        }
        return this.volumes;
    }

    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
    }

    @Input
    @Optional
    public Map<String, String> getLabels() {
        if (System.getProperty("jib.container.labels") != null) {
            return ConfigurationPropertyValidator.parseMapProperty(System.getProperty("jib.container.labels"));
        }
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    @Input
    @Optional
    public String getAppRoot() {
        if (System.getProperty("jib.container.appRoot") != null) {
            return System.getProperty("jib.container.appRoot");
        }
        return this.appRoot;
    }

    public void setAppRoot(String appRoot) {
        this.appRoot = appRoot;
    }

    @Input
    @Nullable
    @Optional
    public String getUser() {
        if (System.getProperty("jib.container.user") != null) {
            return System.getProperty("jib.container.user");
        }
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Input
    @Nullable
    @Optional
    public String getWorkingDirectory() {
        if (System.getProperty("jib.container.workingDirectory") != null) {
            return System.getProperty("jib.container.workingDirectory");
        }
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }
}

