/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.gradle.GradleHelpfulSuggestionsBuilder;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.GradleRawConfiguration;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.JibTask;
import com.google.cloud.tools.jib.gradle.TaskCommon;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.IncompatibleBaseImageJavaVersionException;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerVolumeException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerizingModeException;
import com.google.cloud.tools.jib.plugins.common.InvalidWorkingDirectoryException;
import com.google.cloud.tools.jib.plugins.common.JibBuildRunner;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class BuildImageTask
extends DefaultTask
implements JibTask {
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Build image failed";
    @Nullable
    private JibExtension jibExtension;

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @Option(option="image", description="The image reference for the target image")
    public void setTargetImage(String targetImage) {
        ((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getTo().setImage(targetImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void buildImage() throws IOException, BuildStepsExecutionException, CacheDirectoryCreationException, MainClassInferenceException {
        Preconditions.checkNotNull((Object)this.jibExtension);
        TaskCommon.checkDeprecatedUsage(this.jibExtension, this.getLogger());
        TaskCommon.disableHttpLogging();
        try {
            GradleRawConfiguration gradleRawConfiguration = new GradleRawConfiguration(this.jibExtension);
            GradleProjectProperties projectProperties = GradleProjectProperties.getForProject(this.getProject(), this.getLogger());
            if (Strings.isNullOrEmpty((String)this.jibExtension.getTo().getImage())) {
                throw new GradleException(HelpfulSuggestions.forToNotConfigured("Missing target image parameter", "'jib.to.image'", "build.gradle", "gradle jib --image <your image name>"));
            }
            PluginConfigurationProcessor pluginConfigurationProcessor = PluginConfigurationProcessor.processCommonConfigurationForRegistryImage(gradleRawConfiguration, ignored -> Optional.empty(), projectProperties);
            ImageReference targetImageReference = pluginConfigurationProcessor.getTargetImageReference();
            HelpfulSuggestions helpfulSuggestions = new GradleHelpfulSuggestionsBuilder(HELPFUL_SUGGESTIONS_PREFIX, this.jibExtension).setBaseImageReference(pluginConfigurationProcessor.getBaseImageReference()).setBaseImageHasConfiguredCredentials(pluginConfigurationProcessor.isBaseImageCredentialPresent()).setTargetImageReference(targetImageReference).setTargetImageHasConfiguredCredentials(pluginConfigurationProcessor.isTargetImageCredentialPresent()).build();
            Path buildOutput = this.getProject().getBuildDir().toPath();
            try {
                JibBuildRunner.forBuildImage(targetImageReference, this.jibExtension.getTo().getTags()).writeImageDigest(buildOutput.resolve("jib-image.digest")).writeImageId(buildOutput.resolve("jib-image.id")).build(pluginConfigurationProcessor.getJibContainerBuilder(), pluginConfigurationProcessor.getContainerizer(), projectProperties::log, helpfulSuggestions);
            }
            finally {
                projectProperties.waitForLoggingThread();
            }
        }
        catch (InvalidAppRootException ex) {
            throw new GradleException("container.appRoot is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Throwable)ex);
        }
        catch (InvalidContainerizingModeException ex) {
            throw new GradleException("invalid value for containerizingMode: " + ex.getInvalidContainerizingMode(), (Throwable)ex);
        }
        catch (InvalidWorkingDirectoryException ex) {
            throw new GradleException("container.workingDirectory is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Throwable)ex);
        }
        catch (InvalidContainerVolumeException ex) {
            throw new GradleException("container.volumes is not an absolute Unix-style path: " + ex.getInvalidVolume(), (Throwable)ex);
        }
        catch (IncompatibleBaseImageJavaVersionException ex) {
            throw new GradleException(HelpfulSuggestions.forIncompatibleBaseImageJavaVesionForGradle(ex.getBaseImageMajorJavaVersion(), ex.getProjectMajorJavaVersion()), (Throwable)ex);
        }
        catch (InvalidImageReferenceException ex) {
            throw new GradleException(HelpfulSuggestions.forInvalidImageReference(ex.getInvalidReference()), (Throwable)ex);
        }
    }

    @Override
    public BuildImageTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }
}

