/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.common.base.Splitter;
import java.nio.file.Path;
import java.security.DigestException;

class CacheStorageFiles {
    private static final String LAYERS_DIRECTORY = "layers";
    private static final String IMAGES_DIRECTORY = "images";
    private static final String SELECTORS_DIRECTORY = "selectors";
    private static final String TEMPORARY_DIRECTORY = "tmp";
    private static final String TEMPORARY_LAYER_FILE_NAME = ".tmp.layer";
    private final Path cacheDirectory;

    static boolean isLayerFile(Path file) {
        return file.getFileName().toString().length() == 64;
    }

    CacheStorageFiles(Path cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    DescriptorDigest getDiffId(Path layerFile) throws CacheCorruptedException {
        try {
            String diffId = layerFile.getFileName().toString();
            return DescriptorDigest.fromHash(diffId);
        }
        catch (IndexOutOfBoundsException | DigestException ex) {
            throw new CacheCorruptedException(this.cacheDirectory, "Layer file did not include valid diff ID: " + layerFile, ex);
        }
    }

    Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    Path getLayerFile(DescriptorDigest layerDigest, DescriptorDigest layerDiffId) {
        return this.getLayerDirectory(layerDigest).resolve(this.getLayerFilename(layerDiffId));
    }

    String getLayerFilename(DescriptorDigest layerDiffId) {
        return layerDiffId.getHash();
    }

    Path getSelectorFile(DescriptorDigest selector) {
        return this.cacheDirectory.resolve(SELECTORS_DIRECTORY).resolve(selector.getHash());
    }

    Path getLayersDirectory() {
        return this.cacheDirectory.resolve(LAYERS_DIRECTORY);
    }

    Path getLayerDirectory(DescriptorDigest layerDigest) {
        return this.getLayersDirectory().resolve(layerDigest.getHash());
    }

    Path getImagesDirectory() {
        return this.cacheDirectory.resolve(IMAGES_DIRECTORY);
    }

    Path getImageDirectory(ImageReference imageReference) {
        String replacedReference = imageReference.toStringWithTag().replace(':', '!').replace('@', '!');
        Iterable directories = Splitter.on((char)'/').split((CharSequence)replacedReference);
        Path destination = this.getImagesDirectory();
        for (String dir : directories) {
            destination = destination.resolve(dir);
        }
        return destination;
    }

    Path getTemporaryDirectory() {
        return this.cacheDirectory.resolve(TEMPORARY_DIRECTORY);
    }

    Path getTemporaryLayerFile(Path layerDirectory) {
        Path temporaryLayerFile = layerDirectory.resolve(TEMPORARY_LAYER_FILE_NAME);
        temporaryLayerFile.toFile().deleteOnExit();
        return temporaryLayerFile;
    }
}

