/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.docker.ImageTarball;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.image.Image;
import java.io.IOException;
import java.util.concurrent.Callable;

class LoadDockerStep
implements Callable<BuildResult> {
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final DockerClient dockerClient;
    private final Image builtImage;

    LoadDockerStep(BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, DockerClient dockerClient, Image builtImage) {
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.dockerClient = dockerClient;
        this.builtImage = builtImage;
    }

    @Override
    public BuildResult call() throws InterruptedException, IOException {
        EventHandlers eventHandlers = this.buildConfiguration.getEventHandlers();
        eventHandlers.dispatch(LogEvent.progress("Loading to Docker daemon..."));
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("loading to Docker daemon", 1L);){
            ImageReference targetImageReference = this.buildConfiguration.getTargetImageConfiguration().getImage();
            eventHandlers.dispatch(LogEvent.debug(this.dockerClient.load(new ImageTarball(this.builtImage, targetImageReference))));
            for (String tag : this.buildConfiguration.getAllTargetImageTags()) {
                if (tag.equals(targetImageReference.getTag())) continue;
                this.dockerClient.tag(targetImageReference, targetImageReference.withTag(tag));
            }
            Object object = BuildResult.fromImage(this.builtImage, this.buildConfiguration.getTargetFormat());
            return object;
        }
    }
}

