/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import java.nio.file.Path;

public class TarImage {
    private final ImageReference imageReference;
    private final Path outputFile;

    public static Builder named(ImageReference imageReference) {
        return new Builder(imageReference);
    }

    public static Builder named(String imageReference) throws InvalidImageReferenceException {
        return TarImage.named(ImageReference.parse(imageReference));
    }

    private TarImage(ImageReference imageReference, Path outputFile) {
        this.imageReference = imageReference;
        this.outputFile = outputFile;
    }

    Path getOutputFile() {
        return this.outputFile;
    }

    ImageReference getImageReference() {
        return this.imageReference;
    }

    public static class Builder {
        private final ImageReference imageReference;

        private Builder(ImageReference imageReference) {
            this.imageReference = imageReference;
        }

        public TarImage saveTo(Path outputFile) {
            return new TarImage(this.imageReference, outputFile);
        }
    }
}

