/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.gradle.GradleBuildLogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

class GradleSourceFilesConfiguration
implements SourceFilesConfiguration {
    private static final String MAIN_SOURCE_SET_NAME = "main";
    private final ImmutableList<Path> dependenciesFiles;
    private final ImmutableList<Path> resourcesFiles;
    private final ImmutableList<Path> classesFiles;

    static GradleSourceFilesConfiguration getForProject(Project project, GradleBuildLogger gradleBuildLogger) throws IOException {
        return new GradleSourceFilesConfiguration(project, gradleBuildLogger);
    }

    private GradleSourceFilesConfiguration(Project project, GradleBuildLogger gradleBuildLogger) throws IOException {
        Path resourcesOutputDirectory;
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName(MAIN_SOURCE_SET_NAME);
        ArrayList<Path> dependenciesFiles = new ArrayList<Path>();
        ArrayList resourcesFiles = new ArrayList();
        ArrayList classesFiles = new ArrayList();
        FileCollection classesOutputDirectories = mainSourceSet.getOutput().getClassesDirs();
        for (File classesOutputDirectory : classesOutputDirectories) {
            if (Files.notExists(classesOutputDirectory.toPath(), new LinkOption[0])) {
                gradleBuildLogger.warn("Could not find build output directory '" + classesOutputDirectory + "'");
                continue;
            }
            Stream<Path> classFileStream = Files.list(classesOutputDirectory.toPath());
            Throwable throwable = null;
            try {
                classFileStream.forEach(classesFiles::add);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (classFileStream == null) continue;
                GradleSourceFilesConfiguration.$closeResource(throwable, classFileStream);
            }
        }
        if (classesFiles.isEmpty()) {
            gradleBuildLogger.warn("No classes files were found - did you compile your project?");
        }
        if (Files.exists(resourcesOutputDirectory = mainSourceSet.getOutput().getResourcesDir().toPath(), new LinkOption[0])) {
            Stream<Path> resourceFileStream = Files.list(resourcesOutputDirectory);
            Object object = null;
            try {
                resourceFileStream.forEach(resourcesFiles::add);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (resourceFileStream != null) {
                    GradleSourceFilesConfiguration.$closeResource((Throwable)object, resourceFileStream);
                }
            }
        }
        FileCollection allFiles = mainSourceSet.getRuntimeClasspath();
        allFiles = allFiles.minus(classesOutputDirectories);
        for (File dependencyFile : allFiles) {
            if (resourcesOutputDirectory.equals(dependencyFile.toPath())) continue;
            dependenciesFiles.add(dependencyFile.toPath());
        }
        this.dependenciesFiles = ImmutableList.sortedCopyOf(dependenciesFiles);
        this.resourcesFiles = ImmutableList.sortedCopyOf(resourcesFiles);
        this.classesFiles = ImmutableList.sortedCopyOf(classesFiles);
    }

    @Override
    public ImmutableList<Path> getDependenciesFiles() {
        return this.dependenciesFiles;
    }

    @Override
    public ImmutableList<Path> getResourcesFiles() {
        return this.resourcesFiles;
    }

    @Override
    public ImmutableList<Path> getClassesFiles() {
        return this.classesFiles;
    }

    @Override
    public String getDependenciesPathOnImage() {
        return "/app/libs/";
    }

    @Override
    public String getResourcesPathOnImage() {
        return "/app/resources/";
    }

    @Override
    public String getClassesPathOnImage() {
        return "/app/classes/";
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

