/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.frontend.MainClassFinder;
import com.google.cloud.tools.jib.frontend.MainClassInferenceException;
import com.google.cloud.tools.jib.frontend.ProjectProperties;
import com.google.cloud.tools.jib.gradle.GradleBuildLogger;
import com.google.cloud.tools.jib.gradle.GradleSourceFilesConfiguration;
import com.google.cloud.tools.jib.gradle.HelpfulSuggestionsProvider;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.jvm.tasks.Jar;

class GradleProjectProperties
implements ProjectProperties {
    private static final String PLUGIN_NAME = "jib";
    private static final String JAR_PLUGIN_NAME = "'jar' task";
    private final Project project;
    private final GradleBuildLogger gradleBuildLogger;
    private final SourceFilesConfiguration sourceFilesConfiguration;

    static GradleProjectProperties getForProject(Project project, GradleBuildLogger gradleBuildLogger) {
        try {
            return new GradleProjectProperties(project, gradleBuildLogger, GradleSourceFilesConfiguration.getForProject(project, gradleBuildLogger));
        }
        catch (IOException ex) {
            throw new GradleException("Obtaining project build output files failed", (Throwable)ex);
        }
    }

    @VisibleForTesting
    GradleProjectProperties(Project project, GradleBuildLogger gradleBuildLogger, SourceFilesConfiguration sourceFilesConfiguration) {
        this.project = project;
        this.gradleBuildLogger = gradleBuildLogger;
        this.sourceFilesConfiguration = sourceFilesConfiguration;
    }

    @Override
    public SourceFilesConfiguration getSourceFilesConfiguration() {
        return this.sourceFilesConfiguration;
    }

    @Override
    public HelpfulSuggestions getMainClassHelpfulSuggestions(String prefix) {
        return HelpfulSuggestionsProvider.get(prefix);
    }

    @Override
    public BuildLogger getLogger() {
        return this.gradleBuildLogger;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    @Nullable
    public String getMainClassFromJar() {
        ArrayList jarTasks = new ArrayList(this.project.getTasksByName("jar", false));
        if (jarTasks.size() != 1) {
            return null;
        }
        return (String)((Jar)jarTasks.get(0)).getManifest().getAttributes().get((Object)"Main-Class");
    }

    @Override
    public Path getCacheDirectory() {
        return this.project.getBuildDir().toPath().resolve("jib-cache");
    }

    @Override
    public String getJarPluginName() {
        return JAR_PLUGIN_NAME;
    }

    String getMainClass(JibExtension jibExtension) {
        try {
            return MainClassFinder.resolveMainClass(jibExtension.getMainClass(), this);
        }
        catch (MainClassInferenceException ex) {
            throw new GradleException(ex.getMessage(), (Throwable)ex);
        }
    }
}

