/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.frontend.BuildStepsExecutionException;
import com.google.cloud.tools.jib.frontend.BuildStepsRunner;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.gradle.GradleBuildLogger;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.HelpfulSuggestionsProvider;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class BuildDockerTask
extends DefaultTask {
    private static final String USER_AGENT_SUFFIX = "jib-gradle-plugin";
    private static final HelpfulSuggestions HELPFUL_SUGGESTIONS = HelpfulSuggestionsProvider.get("Build to Docker daemon failed");
    @Nullable
    private JibExtension jibExtension;

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @Option(option="image", description="The image reference for the target image")
    public void setTargetImage(String targetImage) {
        ((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getTo().setImage(targetImage);
    }

    @TaskAction
    public void buildDocker() throws InvalidImageReferenceException, IOException {
        if (!new DockerClient().isDockerInstalled()) {
            throw new GradleException(HELPFUL_SUGGESTIONS.forDockerNotInstalled());
        }
        Preconditions.checkNotNull((Object)this.jibExtension);
        GradleBuildLogger gradleBuildLogger = new GradleBuildLogger(this.getLogger());
        this.jibExtension.handleDeprecatedParameters(gradleBuildLogger);
        RegistryCredentials knownBaseRegistryCredentials = null;
        Authorization fromAuthorization = this.jibExtension.getFrom().getImageAuthorization();
        if (fromAuthorization != null) {
            knownBaseRegistryCredentials = new RegistryCredentials("jib.from.auth", fromAuthorization);
        }
        GradleProjectProperties gradleProjectProperties = GradleProjectProperties.getForProject(this.getProject(), gradleBuildLogger);
        String mainClass = gradleProjectProperties.getMainClass(this.jibExtension);
        ImageReference targetImage = this.getDockerTag(gradleBuildLogger);
        BuildConfiguration.Builder buildConfigurationBuilder = BuildConfiguration.builder(gradleBuildLogger).setBaseImage(ImageReference.parse(this.jibExtension.getBaseImage())).setTargetImage(targetImage).setBaseImageCredentialHelperName(this.jibExtension.getFrom().getCredHelper()).setKnownBaseRegistryCredentials(knownBaseRegistryCredentials).setMainClass(mainClass).setJavaArguments(this.jibExtension.getArgs()).setJvmFlags(this.jibExtension.getJvmFlags()).setExposedPorts((List<Port>)ExposedPortsParser.parse(this.jibExtension.getExposedPorts())).setAllowHttp(this.jibExtension.getAllowInsecureRegistries());
        if (Files.exists(this.jibExtension.getExtraDirectory().toPath(), new LinkOption[0])) {
            try (Stream<Path> extraFilesLayerDirectoryFiles = Files.list(this.jibExtension.getExtraDirectory().toPath());){
                buildConfigurationBuilder.setExtraFilesLayerConfiguration(LayerConfiguration.builder().addEntry(extraFilesLayerDirectoryFiles.collect(Collectors.toList()), "/").build());
            }
        }
        CacheConfiguration applicationLayersCacheConfiguration = CacheConfiguration.forPath(gradleProjectProperties.getCacheDirectory());
        buildConfigurationBuilder.setApplicationLayersCacheConfiguration(applicationLayersCacheConfiguration);
        if (this.jibExtension.getUseOnlyProjectCache()) {
            buildConfigurationBuilder.setBaseImageLayersCacheConfiguration(applicationLayersCacheConfiguration);
        }
        BuildConfiguration buildConfiguration = buildConfigurationBuilder.build();
        GradleBuildLogger.disableHttpLogging();
        RegistryClient.setUserAgentSuffix(USER_AGENT_SUFFIX);
        try {
            BuildStepsRunner.forBuildToDockerDaemon(buildConfiguration, gradleProjectProperties.getSourceFilesConfiguration()).build(HELPFUL_SUGGESTIONS);
        }
        catch (CacheDirectoryCreationException | BuildStepsExecutionException ex) {
            throw new GradleException(ex.getMessage(), ex.getCause());
        }
    }

    BuildDockerTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }

    ImageReference getDockerTag(GradleBuildLogger gradleBuildLogger) throws InvalidImageReferenceException {
        Preconditions.checkNotNull((Object)this.jibExtension);
        if (Strings.isNullOrEmpty((String)this.jibExtension.getTargetImage())) {
            gradleBuildLogger.lifecycle("Tagging image with generated image reference " + this.getProject().getName() + ":" + this.getProject().getVersion().toString() + ". If you'd like to specify a different tag, you can set the jib.to.image parameter in your build.gradle, or use the --image=<MY IMAGE> commandline flag.");
            return ImageReference.of(null, this.getProject().getName(), this.getProject().getVersion().toString());
        }
        return ImageReference.parse(this.jibExtension.getTargetImage());
    }
}

