/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import java.util.Objects;
import javax.annotation.Nullable;

public class Port {
    private final int port;
    private final Protocol protocol;

    public Port(int port, Protocol protocol) {
        this.port = port;
        this.protocol = protocol;
    }

    public int getPort() {
        return this.port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof Port)) {
            return false;
        }
        Port otherPort = (Port)other;
        return this.port == otherPort.port && this.protocol == otherPort.protocol;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.port, this.protocol});
    }

    public String toString() {
        return this.port + "/" + (Object)((Object)this.protocol);
    }

    public static enum Protocol {
        TCP("tcp"),
        UDP("udp");

        private final String stringRepresentation;

        private Protocol(String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        public static Protocol getFromString(@Nullable String protocolString) {
            if (protocolString == null) {
                return TCP;
            }
            return UDP.toString().equalsIgnoreCase(protocolString) ? UDP : TCP;
        }
    }
}

