/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.configuration.credentials.CredentialRetriever;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import java.io.FileNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class DefaultCredentialRetrievers {
    private final CredentialRetrieverFactory credentialRetrieverFactory;
    @Nullable
    private CredentialRetriever knownCredentialRetriever;
    @Nullable
    private CredentialRetriever inferredCredentialRetriever;
    @Nullable
    private String credentialHelper;

    public static DefaultCredentialRetrievers init(CredentialRetrieverFactory credentialRetrieverFactory) {
        return new DefaultCredentialRetrievers(credentialRetrieverFactory);
    }

    private DefaultCredentialRetrievers(CredentialRetrieverFactory credentialRetrieverFactory) {
        this.credentialRetrieverFactory = credentialRetrieverFactory;
    }

    public DefaultCredentialRetrievers setKnownCredential(Credential knownCredential, String credentialSource) {
        this.knownCredentialRetriever = this.credentialRetrieverFactory.known(knownCredential, credentialSource);
        return this;
    }

    public DefaultCredentialRetrievers setInferredCredential(Credential inferredCredential, String credentialSource) {
        this.inferredCredentialRetriever = this.credentialRetrieverFactory.known(inferredCredential, credentialSource);
        return this;
    }

    public DefaultCredentialRetrievers setCredentialHelper(@Nullable String credentialHelper) {
        this.credentialHelper = credentialHelper;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<CredentialRetriever> asList() throws FileNotFoundException {
        ArrayList<CredentialRetriever> credentialRetrievers = new ArrayList<CredentialRetriever>();
        if (this.knownCredentialRetriever != null) {
            credentialRetrievers.add(this.knownCredentialRetriever);
        }
        if (this.credentialHelper != null) {
            if (this.credentialHelper.contains(FileSystems.getDefault().getSeparator())) {
                if (!Files.exists(Paths.get(this.credentialHelper, new String[0]), new LinkOption[0])) throw new FileNotFoundException("Specified credential helper was not found: " + this.credentialHelper);
                credentialRetrievers.add(this.credentialRetrieverFactory.dockerCredentialHelper(this.credentialHelper));
            } else {
                credentialRetrievers.add(this.credentialRetrieverFactory.dockerCredentialHelper("docker-credential-" + this.credentialHelper));
            }
        }
        if (this.inferredCredentialRetriever != null) {
            credentialRetrievers.add(this.inferredCredentialRetriever);
        }
        credentialRetrievers.add(this.credentialRetrieverFactory.inferCredentialHelper());
        credentialRetrievers.add(this.credentialRetrieverFactory.dockerConfig());
        return credentialRetrievers;
    }
}

