/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.HistoryEntry;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ImageToJsonTranslator {
    private final Image<Layer> image;

    @Nullable
    @VisibleForTesting
    static Map<String, Map<?, ?>> portListToMap(@Nullable List<Port> exposedPorts) {
        if (exposedPorts == null) {
            return null;
        }
        ImmutableSortedMap.Builder result = new ImmutableSortedMap.Builder(String::compareTo);
        for (Port port : exposedPorts) {
            result.put((Object)(port.getPort() + "/" + port.getProtocol()), Collections.emptyMap());
        }
        return result.build();
    }

    @Nullable
    @VisibleForTesting
    static ImmutableList<String> environmentMapToList(@Nullable Map<String, String> environment) {
        if (environment == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)environment.keySet().stream().noneMatch(key -> key.contains("=")), (Object)"Illegal environment variable: name cannot contain '='");
        return (ImmutableList)environment.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(ImmutableList.toImmutableList());
    }

    public ImageToJsonTranslator(Image<Layer> image) {
        this.image = image;
    }

    public Blob getContainerConfigurationBlob() {
        ContainerConfigurationTemplate template = new ContainerConfigurationTemplate();
        for (Layer layer : this.image.getLayers()) {
            template.addLayerDiffId(layer.getDiffId());
        }
        for (HistoryEntry historyObject : this.image.getHistory()) {
            template.addHistoryEntry(historyObject);
        }
        template.setCreated(this.image.getCreated() == null ? null : this.image.getCreated().toString());
        template.setContainerEnvironment((List<String>)ImageToJsonTranslator.environmentMapToList(this.image.getEnvironment()));
        template.setContainerEntrypoint((List<String>)this.image.getEntrypoint());
        template.setContainerCmd((List<String>)this.image.getProgramArguments());
        template.setContainerExposedPorts(ImageToJsonTranslator.portListToMap(this.image.getExposedPorts()));
        template.setContainerLabels((Map<String, String>)this.image.getLabels());
        template.setContainerWorkingDir(this.image.getWorkingDirectory());
        template.setContainerUser(this.image.getUser());
        return JsonTemplateMapper.toBlob(template);
    }

    public <T extends BuildableManifestTemplate> T getManifestTemplate(Class<T> manifestTemplateClass, BlobDescriptor containerConfigurationBlobDescriptor) {
        try {
            BuildableManifestTemplate template = (BuildableManifestTemplate)manifestTemplateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DescriptorDigest containerConfigurationDigest = containerConfigurationBlobDescriptor.getDigest();
            long containerConfigurationSize = containerConfigurationBlobDescriptor.getSize();
            template.setContainerConfiguration(containerConfigurationSize, containerConfigurationDigest);
            for (Layer layer : this.image.getLayers()) {
                template.addLayer(layer.getBlobDescriptor().getSize(), layer.getBlobDescriptor().getDigest());
            }
            return (T)template;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalArgumentException(manifestTemplateClass + " cannot be instantiated", ex);
        }
    }
}

