/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.HistoryEntry;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContainerConfigurationTemplate
implements JsonTemplate {
    @Nullable
    private String created;
    private String architecture = "amd64";
    private String os = "linux";
    private final ConfigurationObjectTemplate config = new ConfigurationObjectTemplate();
    private final List<HistoryEntry> history = new ArrayList<HistoryEntry>();
    private final RootFilesystemObjectTemplate rootfs = new RootFilesystemObjectTemplate();

    public void setCreated(@Nullable String created) {
        this.created = created;
    }

    public void setContainerEnvironment(@Nullable List<String> environment) {
        this.config.Env = environment;
    }

    public void setContainerEntrypoint(@Nullable List<String> command) {
        this.config.Entrypoint = command;
    }

    public void setContainerCmd(@Nullable List<String> cmd) {
        this.config.Cmd = cmd;
    }

    public void setContainerExposedPorts(@Nullable Map<String, Map<?, ?>> exposedPorts) {
        this.config.ExposedPorts = exposedPorts;
    }

    public void setContainerLabels(@Nullable Map<String, String> labels) {
        this.config.Labels = labels;
    }

    public void setContainerWorkingDir(@Nullable String workingDirectory) {
        this.config.WorkingDir = workingDirectory;
    }

    public void setContainerUser(@Nullable String user) {
        this.config.User = user;
    }

    public void addLayerDiffId(DescriptorDigest diffId) {
        this.rootfs.diff_ids.add(diffId);
    }

    public void addHistoryEntry(HistoryEntry historyEntry) {
        this.history.add(historyEntry);
    }

    List<DescriptorDigest> getDiffIds() {
        return this.rootfs.diff_ids;
    }

    List<HistoryEntry> getHistory() {
        return this.history;
    }

    @Nullable
    String getCreated() {
        return this.created;
    }

    @Nullable
    List<String> getContainerEnvironment() {
        return this.config.Env;
    }

    @Nullable
    List<String> getContainerEntrypoint() {
        return this.config.Entrypoint;
    }

    @Nullable
    List<String> getContainerCmd() {
        return this.config.Cmd;
    }

    @Nullable
    Map<String, Map<?, ?>> getContainerExposedPorts() {
        return this.config.ExposedPorts;
    }

    @Nullable
    Map<String, String> getContainerLabels() {
        return this.config.Labels;
    }

    @Nullable
    String getContainerWorkingDir() {
        return this.config.WorkingDir;
    }

    @Nullable
    String getContainerUser() {
        return this.config.User;
    }

    @VisibleForTesting
    DescriptorDigest getLayerDiffId(int index) {
        return (DescriptorDigest)this.rootfs.diff_ids.get(index);
    }

    private static class RootFilesystemObjectTemplate
    implements JsonTemplate {
        private final String type = "layers";
        private final List<DescriptorDigest> diff_ids = new ArrayList<DescriptorDigest>();

        private RootFilesystemObjectTemplate() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ConfigurationObjectTemplate
    implements JsonTemplate {
        @Nullable
        private List<String> Env;
        @Nullable
        private List<String> Entrypoint;
        @Nullable
        private List<String> Cmd;
        @Nullable
        private Map<String, Map<?, ?>> ExposedPorts;
        @Nullable
        private Map<String, String> Labels;
        @Nullable
        private String WorkingDir;
        @Nullable
        private String User;

        private ConfigurationObjectTemplate() {
        }
    }
}

