/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.configuration.FilePermissions;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nullable;

public class LayerEntry {
    private final Path sourceFile;
    private final AbsoluteUnixPath extractionPath;
    private final FilePermissions permissions;

    public LayerEntry(Path sourceFile, AbsoluteUnixPath extractionPath, @Nullable FilePermissions permissions) {
        this.sourceFile = sourceFile;
        this.extractionPath = extractionPath;
        this.permissions = permissions == null ? (Files.isDirectory(sourceFile, new LinkOption[0]) ? FilePermissions.DEFAULT_FOLDER_PERMISSIONS : FilePermissions.DEFAULT_FILE_PERMISSIONS) : permissions;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public AbsoluteUnixPath getExtractionPath() {
        return this.extractionPath;
    }

    public FilePermissions getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayerEntry)) {
            return false;
        }
        LayerEntry otherLayerEntry = (LayerEntry)other;
        return this.sourceFile.equals(otherLayerEntry.sourceFile) && this.extractionPath.equals(otherLayerEntry.extractionPath) && Objects.equals(this.permissions, otherLayerEntry.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.sourceFile, this.extractionPath, this.permissions);
    }
}

