/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Connection
implements Closeable {
    private HttpRequestFactory requestFactory;
    @Nullable
    private HttpResponse httpResponse;
    private final GenericUrl url;

    public static Function<URL, Connection> getConnectionFactory() {
        ApacheHttpTransport transport = new ApacheHttpTransport();
        return arg_0 -> Connection.lambda$getConnectionFactory$0((HttpTransport)transport, arg_0);
    }

    public static Function<URL, Connection> getInsecureConnectionFactory() throws GeneralSecurityException {
        ApacheHttpTransport transport = new ApacheHttpTransport.Builder().doNotValidateCertificate().build();
        return arg_0 -> Connection.lambda$getInsecureConnectionFactory$1((HttpTransport)transport, arg_0);
    }

    @VisibleForTesting
    Connection(URL url, HttpTransport transport) {
        this.url = new GenericUrl(url);
        this.requestFactory = transport.createRequestFactory();
    }

    @Override
    public void close() throws IOException {
        if (this.httpResponse == null) {
            return;
        }
        this.httpResponse.disconnect();
    }

    public Response get(Request request) throws IOException {
        return this.send("GET", request);
    }

    public Response post(Request request) throws IOException {
        return this.send("POST", request);
    }

    public Response put(Request request) throws IOException {
        return this.send("PUT", request);
    }

    public Response send(String httpMethod, Request request) throws IOException {
        Preconditions.checkState((this.httpResponse == null ? 1 : 0) != 0, (Object)"Connection can send only one request");
        HttpRequest httpRequest = this.requestFactory.buildRequest(httpMethod, this.url, (HttpContent)request.getHttpContent()).setHeaders(request.getHeaders());
        if (request.getHttpTimeout() != null) {
            httpRequest.setConnectTimeout(request.getHttpTimeout().intValue());
            httpRequest.setReadTimeout(request.getHttpTimeout().intValue());
        }
        this.httpResponse = httpRequest.execute();
        return new Response(this.httpResponse);
    }

    private static /* synthetic */ Connection lambda$getInsecureConnectionFactory$1(HttpTransport transport, URL url) {
        return new Connection(url, transport);
    }

    private static /* synthetic */ Connection lambda$getConnectionFactory$0(HttpTransport transport, URL url) {
        return new Connection(url, transport);
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "error");
    }
}

