/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.api.client.http.HttpTransport;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.plugins.common.AppRootInvalidException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gradle.api.Project;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.slf4j.OutputEventListenerBackedLoggerContext;
import org.slf4j.LoggerFactory;

class TaskCommon {
    static AbsoluteUnixPath getAppRootChecked(JibExtension jibExtension, Project project) throws AppRootInvalidException {
        String appRoot = jibExtension.getContainer().getAppRoot();
        if (appRoot.isEmpty()) {
            appRoot = GradleProjectProperties.getWarTask(project) != null ? "/jetty/webapps/ROOT" : "/app";
        }
        try {
            return AbsoluteUnixPath.get(appRoot);
        }
        catch (IllegalArgumentException ex) {
            throw new AppRootInvalidException(appRoot, appRoot, ex);
        }
    }

    static void disableHttpLogging() {
        OutputEventListenerBackedLoggerContext context = (OutputEventListenerBackedLoggerContext)LoggerFactory.getILoggerFactory();
        OutputEventListener defaultOutputEventListener = context.getOutputEventListener();
        context.setOutputEventListener(event -> {
            LogEvent logEvent = (LogEvent)event;
            if (!logEvent.getCategory().contains("org.apache")) {
                defaultOutputEventListener.onOutput(event);
            }
        });
        Logger.getLogger(HttpTransport.class.getName()).setLevel(Level.OFF);
    }

    private TaskCommon() {
    }
}

