/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.AuthParameters;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public class TargetImageParameters {
    private final AuthParameters auth;
    @Nullable
    private String image;
    private Set<String> tags = Collections.emptySet();
    @Nullable
    private String credHelper;

    @Inject
    public TargetImageParameters(ObjectFactory objectFactory, String imageDescriptor) {
        this.auth = (AuthParameters)objectFactory.newInstance(AuthParameters.class, new Object[]{imageDescriptor + ".auth"});
    }

    @Input
    @Nullable
    @Optional
    public String getImage() {
        if (System.getProperty("jib.to.image") != null) {
            return System.getProperty("jib.to.image");
        }
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Input
    @Optional
    public Set<String> getTags() {
        if (System.getProperty("jib.to.tags") != null) {
            return ImmutableSet.copyOf(ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.to.tags")));
        }
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Input
    @Nullable
    @Optional
    public String getCredHelper() {
        if (System.getProperty("jib.to.credHelper") != null) {
            return System.getProperty("jib.to.credHelper");
        }
        return this.credHelper;
    }

    public void setCredHelper(String credHelper) {
        this.credHelper = credHelper;
    }

    @Nested
    @Optional
    public AuthParameters getAuth() {
        return this.auth;
    }

    public void auth(Action<? super AuthParameters> action) {
        action.execute((Object)this.auth);
    }
}

