/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.JavaDockerContextGenerator;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.GradleRawConfiguration;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.JibTask;
import com.google.cloud.tools.jib.gradle.TaskCommon;
import com.google.cloud.tools.jib.plugins.common.AppRootInvalidException;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.base.Preconditions;
import com.google.common.io.InsecureRecursiveDeleteException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class DockerContextTask
extends DefaultTask
implements JibTask {
    @Nullable
    private String targetDir;
    @Nullable
    private JibExtension jibExtension;

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @InputFiles
    public FileCollection getInputFiles() {
        return GradleProjectProperties.getInputFiles(((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getExtraDirectory().getPath().toFile(), this.getProject());
    }

    @OutputDirectory
    public String getOutputDirectory() {
        return this.getTargetDir();
    }

    @Input
    public String getTargetDir() {
        if (this.targetDir == null) {
            return this.getProject().getBuildDir().toPath().resolve("jib-docker-context").toString();
        }
        return this.targetDir;
    }

    @Option(option="jibTargetDir", description="Directory to output the Docker context to")
    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    @TaskAction
    public void generateDockerContext() throws MainClassInferenceException {
        Preconditions.checkNotNull((Object)this.jibExtension);
        JibSystemProperties.checkHttpTimeoutProperty();
        TaskCommon.disableHttpLogging();
        if (!this.jibExtension.getExtraDirectory().getPermissions().isEmpty()) {
            this.getLogger().warn("'jib.extraDirectory.permissions' configuration is not supported by Jib Docker context generator - building using Docker may produce unexpected results.");
        }
        try {
            AbsoluteUnixPath appRoot = TaskCommon.getAppRootChecked(this.jibExtension, this.getProject());
            GradleProjectProperties projectProperties = GradleProjectProperties.getForProject(this.getProject(), this.getLogger(), this.jibExtension.getExtraDirectory().getPath(), this.jibExtension.getExtraDirectory().getPermissions(), appRoot);
            GradleRawConfiguration rawConfiguration = new GradleRawConfiguration(this.jibExtension);
            String targetDir = this.getTargetDir();
            List<String> entrypoint = PluginConfigurationProcessor.computeEntrypoint(rawConfiguration, projectProperties);
            String baseImage = PluginConfigurationProcessor.getBaseImage(rawConfiguration, projectProperties);
            ExposedPortsParser.parse(this.jibExtension.getContainer().getPorts());
            new JavaDockerContextGenerator(projectProperties.getJavaLayerConfigurations()).setBaseImage(baseImage).setEntrypoint(entrypoint).setProgramArguments(this.jibExtension.getContainer().getArgs()).setExposedPorts(this.jibExtension.getContainer().getPorts()).setEnvironment(this.jibExtension.getContainer().getEnvironment()).setLabels(this.jibExtension.getContainer().getLabels()).setUser(this.jibExtension.getContainer().getUser()).generate(Paths.get(targetDir, new String[0]));
            this.getLogger().lifecycle("Created Docker context at " + targetDir);
        }
        catch (InsecureRecursiveDeleteException ex) {
            throw new GradleException(HelpfulSuggestions.forDockerContextInsecureRecursiveDelete("Export Docker context failed because cannot clear directory '" + this.getTargetDir() + "' safely", this.getTargetDir()), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new GradleException(HelpfulSuggestions.suggest("Export Docker context failed", "check if the command-line option `--jibTargetDir` is set correctly"), (Throwable)ex);
        }
        catch (AppRootInvalidException ex) {
            throw new GradleException("container.appRoot is not an absolute Unix-style path: " + ex.getInvalidAppRoot());
        }
    }

    @Override
    public DockerContextTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }
}

