/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.configuration.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.event.DefaultEventDispatcher;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.gradle.DockerClientParameters;
import com.google.cloud.tools.jib.gradle.GradleHelpfulSuggestionsBuilder;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.GradleRawConfiguration;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.JibTask;
import com.google.cloud.tools.jib.gradle.TaskCommon;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.plugins.common.AppRootInvalidException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsRunner;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.InferredAuthRetrievalException;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class BuildDockerTask
extends DefaultTask
implements JibTask {
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Build to Docker daemon failed";
    @Nullable
    private JibExtension jibExtension;
    private final DockerClientParameters dockerClientParameters = new DockerClientParameters();

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @Option(option="image", description="The image reference for the target image")
    public void setTargetImage(String targetImage) {
        ((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getTo().setImage(targetImage);
    }

    @Nested
    @Optional
    public DockerClientParameters getDockerClient() {
        return this.dockerClientParameters;
    }

    public void dockerClient(Action<? super DockerClientParameters> action) {
        action.execute((Object)this.dockerClientParameters);
    }

    @TaskAction
    public void buildDocker() throws InvalidImageReferenceException, IOException, BuildStepsExecutionException, CacheDirectoryCreationException, MainClassInferenceException, InferredAuthRetrievalException {
        boolean isDockerInstalled;
        Path dockerExecutable = this.dockerClientParameters.getExecutable();
        boolean bl = isDockerInstalled = dockerExecutable == null ? DockerClient.isDefaultDockerInstalled() : DockerClient.isDockerInstalled(dockerExecutable);
        if (!isDockerInstalled) {
            throw new GradleException(HelpfulSuggestions.forDockerNotInstalled(HELPFUL_SUGGESTIONS_PREFIX));
        }
        Preconditions.checkNotNull((Object)this.jibExtension);
        TaskCommon.disableHttpLogging();
        try {
            AbsoluteUnixPath appRoot = TaskCommon.getAppRootChecked(this.jibExtension, this.getProject());
            GradleProjectProperties projectProperties = GradleProjectProperties.getForProject(this.getProject(), this.getLogger(), this.jibExtension.getExtraDirectory().getPath(), this.jibExtension.getExtraDirectory().getPermissions(), appRoot);
            GradleRawConfiguration rawConfiguration = new GradleRawConfiguration(this.jibExtension);
            GradleHelpfulSuggestionsBuilder gradleHelpfulSuggestionsBuilder = new GradleHelpfulSuggestionsBuilder(HELPFUL_SUGGESTIONS_PREFIX, this.jibExtension);
            PluginConfigurationProcessor pluginConfigurationProcessor = PluginConfigurationProcessor.processCommonConfigurationForDockerDaemonImage(rawConfiguration, projectProperties, this.dockerClientParameters.getExecutable(), this.dockerClientParameters.getEnvironment(), gradleHelpfulSuggestionsBuilder.build());
            ImageReference targetImageReference = pluginConfigurationProcessor.getTargetImageReference();
            HelpfulSuggestions helpfulSuggestions = gradleHelpfulSuggestionsBuilder.setBaseImageReference(pluginConfigurationProcessor.getBaseImageReference()).setBaseImageHasConfiguredCredentials(pluginConfigurationProcessor.isBaseImageCredentialPresent()).setTargetImageReference(targetImageReference).build();
            Path buildOutput = this.getProject().getBuildDir().toPath();
            BuildStepsRunner.forBuildToDockerDaemon(targetImageReference, this.jibExtension.getTo().getTags()).writeImageDigest(buildOutput.resolve("jib-image.digest")).build(pluginConfigurationProcessor.getJibContainerBuilder(), pluginConfigurationProcessor.getContainerizer(), new DefaultEventDispatcher(projectProperties.getEventHandlers()), (List<LayerConfiguration>)projectProperties.getJavaLayerConfigurations().getLayerConfigurations(), helpfulSuggestions);
        }
        catch (AppRootInvalidException ex) {
            throw new GradleException("container.appRoot is not an absolute Unix-style path: " + ex.getInvalidAppRoot());
        }
    }

    @Override
    public BuildDockerTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }
}

