/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.configuration.FilePermissions;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class JavaLayerConfigurations {
    public static final String DEFAULT_APP_ROOT = "/app";
    public static final String DEFAULT_WEB_APP_ROOT = "/jetty/webapps/ROOT";
    private final ImmutableMap<LayerType, LayerConfiguration> layerConfigurationMap;

    public static Builder builder() {
        return new Builder();
    }

    private JavaLayerConfigurations(ImmutableMap<LayerType, LayerConfiguration> layerConfigurationMap) {
        this.layerConfigurationMap = layerConfigurationMap;
    }

    public ImmutableList<LayerConfiguration> getLayerConfigurations() {
        return this.layerConfigurationMap.values().asList();
    }

    public ImmutableList<LayerEntry> getDependencyLayerEntries() {
        return this.getLayerEntries(LayerType.DEPENDENCIES);
    }

    public ImmutableList<LayerEntry> getSnapshotDependencyLayerEntries() {
        return this.getLayerEntries(LayerType.SNAPSHOT_DEPENDENCIES);
    }

    public ImmutableList<LayerEntry> getResourceLayerEntries() {
        return this.getLayerEntries(LayerType.RESOURCES);
    }

    public ImmutableList<LayerEntry> getClassLayerEntries() {
        return this.getLayerEntries(LayerType.CLASSES);
    }

    public ImmutableList<LayerEntry> getExtraFilesLayerEntries() {
        return this.getLayerEntries(LayerType.EXTRA_FILES);
    }

    private ImmutableList<LayerEntry> getLayerEntries(LayerType layerType) {
        return ((LayerConfiguration)Preconditions.checkNotNull((Object)((LayerConfiguration)this.layerConfigurationMap.get((Object)layerType)))).getLayerEntries();
    }

    public static class Builder {
        private final Map<LayerType, LayerConfiguration.Builder> layerBuilders = new EnumMap<LayerType, LayerConfiguration.Builder>(LayerType.class);

        private Builder() {
            for (LayerType layerType : LayerType.values()) {
                this.layerBuilders.put(layerType, LayerConfiguration.builder());
            }
        }

        public Builder addFile(LayerType layerType, Path sourceFile, AbsoluteUnixPath pathInContainer) {
            return this.addFile(layerType, sourceFile, pathInContainer, null);
        }

        public Builder addFile(LayerType layerType, Path sourceFile, AbsoluteUnixPath pathInContainer, @Nullable FilePermissions permissions) {
            ((LayerConfiguration.Builder)Preconditions.checkNotNull((Object)this.layerBuilders.get((Object)layerType))).addEntry(sourceFile, pathInContainer, permissions);
            return this;
        }

        public Builder addDirectoryContents(LayerType layerType, Path sourceRoot, Predicate<Path> pathFilter, AbsoluteUnixPath basePathInContainer) throws IOException {
            return this.addDirectoryContents(layerType, sourceRoot, pathFilter, basePathInContainer, (Map<AbsoluteUnixPath, FilePermissions>)ImmutableMap.of());
        }

        public Builder addDirectoryContents(LayerType layerType, Path sourceRoot, Predicate<Path> pathFilter, AbsoluteUnixPath basePathInContainer, Map<AbsoluteUnixPath, FilePermissions> permissionsMap) throws IOException {
            LayerConfiguration.Builder builder = (LayerConfiguration.Builder)Preconditions.checkNotNull((Object)this.layerBuilders.get((Object)layerType));
            new DirectoryWalker(sourceRoot).filterRoot().filter(path -> Files.isDirectory(path, new LinkOption[0]) || pathFilter.test((Path)path)).walk(path -> {
                AbsoluteUnixPath pathOnContainer = basePathInContainer.resolve(sourceRoot.relativize(path));
                builder.addEntry(path, pathOnContainer, (FilePermissions)permissionsMap.get(pathOnContainer));
            });
            return this;
        }

        public JavaLayerConfigurations build() {
            ImmutableMap.Builder layerConfigurationsMap = ImmutableMap.builderWithExpectedSize((int)this.layerBuilders.size());
            this.layerBuilders.forEach((type, builder) -> layerConfigurationsMap.put((Object)type, (Object)builder.setName(type.getName()).build()));
            return new JavaLayerConfigurations(layerConfigurationsMap.build());
        }
    }

    public static enum LayerType {
        DEPENDENCIES("dependencies"),
        SNAPSHOT_DEPENDENCIES("snapshot dependencies"),
        RESOURCES("resources"),
        CLASSES("classes"),
        EXTRA_FILES("extra files");

        private final String name;

        private LayerType(String name) {
            this.name = name;
        }

        @VisibleForTesting
        String getName() {
            return this.name;
        }
    }
}

