/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.PushBlobStep;
import com.google.cloud.tools.jib.builder.steps.PushContainerConfigurationStep;
import com.google.cloud.tools.jib.builder.steps.PushLayersStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class PushImageStep
implements AsyncStep<BuildResult>,
Callable<BuildResult> {
    private static final String DESCRIPTION = "Pushing new image";
    private final BuildConfiguration buildConfiguration;
    private final AuthenticatePushStep authenticatePushStep;
    private final PushLayersStep pushBaseImageLayersStep;
    private final PushLayersStep pushApplicationLayersStep;
    private final PushContainerConfigurationStep pushContainerConfigurationStep;
    private final BuildImageStep buildImageStep;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<BuildResult> listenableFuture;

    PushImageStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, AuthenticatePushStep authenticatePushStep, PushLayersStep pushBaseImageLayersStep, PushLayersStep pushApplicationLayersStep, PushContainerConfigurationStep pushContainerConfigurationStep, BuildImageStep buildImageStep) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.authenticatePushStep = authenticatePushStep;
        this.pushBaseImageLayersStep = pushBaseImageLayersStep;
        this.pushApplicationLayersStep = pushApplicationLayersStep;
        this.pushContainerConfigurationStep = pushContainerConfigurationStep;
        this.buildImageStep = buildImageStep;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{pushBaseImageLayersStep.getFuture(), pushApplicationLayersStep.getFuture(), pushContainerConfigurationStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<BuildResult> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public BuildResult call() throws ExecutionException, InterruptedException {
        ImmutableList.Builder dependenciesBuilder = ImmutableList.builder();
        dependenciesBuilder.add(this.authenticatePushStep.getFuture());
        for (AsyncStep pushBlobStepStep : NonBlockingSteps.get(this.pushBaseImageLayersStep)) {
            dependenciesBuilder.add(pushBlobStepStep.getFuture());
        }
        for (AsyncStep pushBlobStepStep : NonBlockingSteps.get(this.pushApplicationLayersStep)) {
            dependenciesBuilder.add(pushBlobStepStep.getFuture());
        }
        dependenciesBuilder.add(NonBlockingSteps.get(this.pushContainerConfigurationStep).getFuture());
        dependenciesBuilder.add(NonBlockingSteps.get(this.buildImageStep).getFuture());
        return (BuildResult)((ListenableFuture)((ListenableFuture)Futures.whenAllSucceed((Iterable)dependenciesBuilder.build()).call(this::afterPushSteps, (Executor)this.listeningExecutorService).get()).get()).get();
    }

    private ListenableFuture<ListenableFuture<BuildResult>> afterPushSteps() throws ExecutionException {
        ArrayList<ListenableFuture<BlobDescriptor>> dependencies = new ArrayList<ListenableFuture<BlobDescriptor>>();
        for (AsyncStep pushBlobStepStep : NonBlockingSteps.get(this.pushBaseImageLayersStep)) {
            dependencies.add(((PushBlobStep)NonBlockingSteps.get(pushBlobStepStep)).getFuture());
        }
        for (AsyncStep pushBlobStepStep : NonBlockingSteps.get(this.pushApplicationLayersStep)) {
            dependencies.add(((PushBlobStep)NonBlockingSteps.get(pushBlobStepStep)).getFuture());
        }
        dependencies.add(NonBlockingSteps.get(NonBlockingSteps.get(this.pushContainerConfigurationStep)).getFuture());
        return Futures.whenAllSucceed(dependencies).call(this::afterAllPushed, (Executor)this.listeningExecutorService);
    }

    private ListenableFuture<BuildResult> afterAllPushed() throws ExecutionException, IOException {
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(this.buildConfiguration.getEventDispatcher(), DESCRIPTION);){
            RegistryClient registryClient = this.buildConfiguration.newTargetImageRegistryClientFactory().setAuthorization(NonBlockingSteps.get(this.authenticatePushStep)).newRegistryClient();
            ImageToJsonTranslator imageToJsonTranslator = new ImageToJsonTranslator(NonBlockingSteps.get(NonBlockingSteps.get(this.buildImageStep)));
            BlobDescriptor containerConfigurationBlobDescriptor = (BlobDescriptor)NonBlockingSteps.get(NonBlockingSteps.get(NonBlockingSteps.get(this.pushContainerConfigurationStep)));
            BuildableManifestTemplate manifestTemplate = imageToJsonTranslator.getManifestTemplate(this.buildConfiguration.getTargetFormat(), containerConfigurationBlobDescriptor);
            ArrayList<ListenableFuture> pushAllTagsFutures = new ArrayList<ListenableFuture>();
            for (String tag : this.buildConfiguration.getAllTargetImageTags()) {
                pushAllTagsFutures.add(this.listeningExecutorService.submit(() -> {
                    this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.info("Tagging with " + tag + "..."));
                    registryClient.pushManifest(manifestTemplate, tag);
                    return null;
                }));
            }
            DescriptorDigest imageDigest = JsonTemplateMapper.toBlob(manifestTemplate).writeTo(ByteStreams.nullOutputStream()).getDigest();
            DescriptorDigest imageId = containerConfigurationBlobDescriptor.getDigest();
            BuildResult result = new BuildResult(imageDigest, imageId);
            ListenableFuture listenableFuture = Futures.whenAllSucceed(pushAllTagsFutures).call(() -> result, (Executor)this.listeningExecutorService);
            return listenableFuture;
        }
    }
}

