/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.image.ReproducibleLayerBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Callable;

class BuildAndCacheApplicationLayerStep
implements AsyncStep<CachedLayer>,
Callable<CachedLayer> {
    private static final String DESCRIPTION = "Building application layers";
    private final String layerType;
    private final BuildConfiguration buildConfiguration;
    private final LayerConfiguration layerConfiguration;
    private final ListenableFuture<CachedLayer> listenableFuture;

    static ImmutableList<BuildAndCacheApplicationLayerStep> makeList(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(buildConfiguration.getEventDispatcher(), DESCRIPTION);){
            ImmutableList.Builder buildAndCacheApplicationLayerSteps = ImmutableList.builderWithExpectedSize((int)buildConfiguration.getLayerConfigurations().size());
            for (LayerConfiguration layerConfiguration : buildConfiguration.getLayerConfigurations()) {
                if (layerConfiguration.getLayerEntries().isEmpty()) continue;
                buildAndCacheApplicationLayerSteps.add((Object)new BuildAndCacheApplicationLayerStep(layerConfiguration.getName(), listeningExecutorService, buildConfiguration, layerConfiguration));
            }
            UnmodifiableIterator unmodifiableIterator = buildAndCacheApplicationLayerSteps.build();
            return unmodifiableIterator;
        }
    }

    private BuildAndCacheApplicationLayerStep(String layerType, ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, LayerConfiguration layerConfiguration) {
        this.layerType = layerType;
        this.buildConfiguration = buildConfiguration;
        this.layerConfiguration = layerConfiguration;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    @Override
    public ListenableFuture<CachedLayer> getFuture() {
        return this.listenableFuture;
    }

    public String getLayerType() {
        return this.layerType;
    }

    @Override
    public CachedLayer call() throws IOException, CacheCorruptedException {
        String description = "Building " + this.layerType + " layer";
        this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.lifecycle(description + "..."));
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(this.buildConfiguration.getEventDispatcher(), description);){
            Cache cache = this.buildConfiguration.getApplicationLayersCache();
            Optional<CachedLayer> optionalCachedLayer = cache.retrieve(this.layerConfiguration.getLayerEntries());
            if (optionalCachedLayer.isPresent()) {
                CachedLayer cachedLayer = optionalCachedLayer.get();
                return cachedLayer;
            }
            Blob layerBlob = new ReproducibleLayerBuilder(this.layerConfiguration.getLayerEntries()).build();
            CachedLayer cachedLayer = cache.writeUncompressedLayer(layerBlob, this.layerConfiguration.getLayerEntries());
            this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.debug(description + " built " + cachedLayer.getDigest()));
            CachedLayer cachedLayer2 = cachedLayer;
            return cachedLayer2;
        }
    }
}

