/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.StepsRunner;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;

public class BuildSteps {
    private static final String DESCRIPTION_FOR_DOCKER_REGISTRY = "Building and pushing image";
    private static final String DESCRIPTION_FOR_DOCKER_DAEMON = "Building image to Docker daemon";
    private static final String DESCRIPTION_FOR_TARBALL = "Building image tarball";
    private final String description;
    private final BuildConfiguration buildConfiguration;
    private final ImageBuildRunnable imageBuildRunnable;

    public static BuildSteps forBuildToDockerRegistry(BuildConfiguration buildConfiguration) {
        return new BuildSteps(DESCRIPTION_FOR_DOCKER_REGISTRY, buildConfiguration, () -> new StepsRunner(buildConfiguration).runRetrieveTargetRegistryCredentialsStep().runAuthenticatePushStep().runPullBaseImageStep().runPullAndCacheBaseImageLayersStep().runPushBaseImageLayersStep().runBuildAndCacheApplicationLayerSteps().runBuildImageStep().runPushContainerConfigurationStep().runPushApplicationLayersStep().runFinalizingPushStep().runPushImageStep().waitOnPushImageStep());
    }

    public static BuildSteps forBuildToDockerDaemon(DockerClient dockerClient, BuildConfiguration buildConfiguration) {
        return new BuildSteps(DESCRIPTION_FOR_DOCKER_DAEMON, buildConfiguration, () -> new StepsRunner(buildConfiguration).runPullBaseImageStep().runPullAndCacheBaseImageLayersStep().runBuildAndCacheApplicationLayerSteps().runBuildImageStep().runFinalizingBuildStep().runLoadDockerStep(dockerClient).waitOnLoadDockerStep());
    }

    public static BuildSteps forBuildToTar(Path outputPath, BuildConfiguration buildConfiguration) {
        return new BuildSteps(DESCRIPTION_FOR_TARBALL, buildConfiguration, () -> new StepsRunner(buildConfiguration).runPullBaseImageStep().runPullAndCacheBaseImageLayersStep().runBuildAndCacheApplicationLayerSteps().runBuildImageStep().runFinalizingBuildStep().runWriteTarFileStep(outputPath).waitOnWriteTarFileStep());
    }

    private BuildSteps(String description, BuildConfiguration buildConfiguration, ImageBuildRunnable imageBuildRunnable) {
        this.description = description;
        this.buildConfiguration = buildConfiguration;
        this.imageBuildRunnable = imageBuildRunnable;
    }

    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    public BuildResult run() throws InterruptedException, ExecutionException {
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(this.buildConfiguration.getEventDispatcher(), this.description);){
            BuildResult buildResult = this.imageBuildRunnable.build();
            return buildResult;
        }
    }

    @FunctionalInterface
    private static interface ImageBuildRunnable {
        public BuildResult build() throws ExecutionException, InterruptedException;
    }
}

