/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.sonos.model;

import com.github.kilianB.sonos.SonosDevice;
import com.github.kilianB.sonos.SonosDiscovery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SonosZoneInfo {
    private final String name;
    private final String id;
    private final List<String> zonePlayerUIDInGroup;

    public SonosZoneInfo(String name, String id, List<String> zonePlayerUIDInGroup) {
        this.name = name;
        this.id = id;
        this.zonePlayerUIDInGroup = zonePlayerUIDInGroup;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getZonePlayerUIDInGroup() {
        return Collections.unmodifiableList(this.zonePlayerUIDInGroup);
    }

    public List<SonosDevice> getSonosDevicesInGroup() {
        ArrayList<SonosDevice> devices = new ArrayList<SonosDevice>();
        for (String uid : this.zonePlayerUIDInGroup) {
            try {
                SonosDevice device = SonosDiscovery.discoverByUID(uid);
                if (device == null) continue;
                devices.add(device);
            }
            catch (IOException iOException) {}
        }
        return devices;
    }
}

