/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.sonos;

import com.github.kilianB.exception.SonosControllerException;
import com.github.kilianB.sonos.CommandBuilder;
import com.github.kilianB.sonos.ParserHelper;
import com.github.kilianB.sonos.listener.AVTTransportListener;
import com.github.kilianB.sonos.listener.MediaRendererQueueListener;
import com.github.kilianB.sonos.listener.RenderingControlListener;
import com.github.kilianB.sonos.listener.SonosEventListener;
import com.github.kilianB.sonos.listener.ZoneTopologyListener;
import com.github.kilianB.sonos.model.PlayMode;
import com.github.kilianB.sonos.model.PlayState;
import com.github.kilianB.sonos.model.SonosSpeakerInfo;
import com.github.kilianB.sonos.model.SonosZoneInfo;
import com.github.kilianB.sonos.model.TrackInfo;
import com.github.kilianB.sonos.model.TrackMetadata;
import com.github.kilianB.uPnPClient.UPnPDevice;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class SonosDevice {
    private UPnPDevice uPnPDevice;
    private boolean uPnPSubscribed = false;
    private static final String MEDIA_SERVER_QUERY_EVENT_ENDPOINT = "/MediaServer/ContentDirectory/Event";
    private static final String MEDIA_SERVER_CONNECTION_EVENT_ENDPOINT = "/MediaServer/ConnectionManager/Event";
    private static final String MEDIA_RENDERER_CONTROL_EVENT_ENDPOINT = "/MediaRenderer/RenderingControl/Event";
    private static final String MEDIA_RENDERER_CONNECTION_EVENT_ENDPOINT = "/MediaRenderer/ConnectionManager/Event";
    private static final String MEDIA_RENDERER_AVTRANSPORT_EVENT_ENDPOINT = "/MediaRenderer/AVTransport/Event";
    private static final String MEDIA_RENDERER_QUEUE_EVENT_ENDPOINT = "/MediaRenderer/Queue/Event";
    private static final String MEDIA_RENDERER_GROUP_CONTROL_EVENT_ENDPOINT = "/MediaRenderer/GroupRenderingControl/Event";
    private static final String ZONE_GROUP_TOPOLOGY_EVENT_ENDPOINT = "/ZoneGroupTopology/Event";
    private static final String SYSTEM_PROPERTIES_EVENT_ENDPOINT = "/SystemProperties/Event";
    private static final String SYSTEM_PROPERTIES_CONTROL_ENDPOINT = "/SystemProperties/Control";
    private static final String ALARM_CLOCK_EVENT_ENDPONT = "/AlarmClock/Event";
    private static final String MUSIC_SERVICE_EVENT_ENDPOINT = "/MusicServices/Event";
    private final String ip;
    private List<SonosEventListener> sonosEventHandlers = new ArrayList<SonosEventListener>();
    private List<String> eventSubscriptions = new ArrayList<String>();
    private String roomName;
    private String deviceName;
    private static final Logger LOGGER = Logger.getLogger(SonosDevice.class.getName());

    public SonosDevice(UPnPDevice device) {
        this.uPnPDevice = device;
        this.ip = device.getIP().getHostAddress();
    }

    @Deprecated
    public SonosDevice(String ip) throws UnknownHostException {
        this.uPnPDevice = UPnPDevice.createDummyDevice(ip);
        this.ip = ip;
    }

    public String getIpAddress() {
        return this.ip;
    }

    public void play() throws IOException, SonosControllerException {
        CommandBuilder.transport("Play").put("InstanceID", "0").put("Speed", "1").executeOn(this.ip);
    }

    public void playUri(String uri, TrackMetadata metadata) throws IOException, SonosControllerException {
        String metadataString = "";
        if (metadata != null) {
            metadataString = metadata.toDIDL();
        }
        System.out.println("Play uri: " + uri);
        CommandBuilder.transport("SetAVTransportURI").put("InstanceID", "0").put("CurrentURI", uri).put("CurrentURIMetaData", metadataString).executeOn(this.ip);
        this.play();
    }

    public void playFromQueue(int queueIndex) throws IOException, SonosControllerException {
        if (queueIndex < 1) {
            throw new IllegalArgumentException("Queue index cannot be < 1.");
        }
        this.playUri("x-rincon-queue:" + this.getSpeakerInfo().getLocalUID() + "#0", null);
        CommandBuilder.transport("Seek").put("InstanceID", "0").put("Unit", "TRACK_NR").put("Target", String.valueOf(queueIndex)).executeOn(this.ip);
        this.play();
    }

    public synchronized void clip(String uri, TrackMetadata metadata) throws IOException, SonosControllerException, InterruptedException {
        PlayState previousState = this.getPlayState();
        TrackInfo previous = this.getCurrentTrackInfo();
        this.playUri(uri, metadata);
        while (!this.getPlayState().equals((Object)PlayState.STOPPED)) {
            Thread.sleep(500L);
        }
        if (!this.getQueue(0, 1).isEmpty()) {
            this.playUri("x-rincon-queue:" + this.getSpeakerInfo().getLocalUID() + "#0", null);
            CommandBuilder.transport("Seek").put("InstanceID", "0").put("Unit", "TRACK_NR").put("Target", String.valueOf(previous.getQueueIndex())).executeOn(this.ip);
            this.seek(previous.getPosition());
            if (previousState.equals((Object)PlayState.PLAYING)) {
                this.play();
            } else {
                this.pause();
            }
        }
    }

    public void pause() throws IOException, SonosControllerException {
        CommandBuilder.transport("Pause").put("InstanceID", "0").put("Speed", "1").executeOn(this.ip);
    }

    public PlayState getPlayState() throws IOException, SonosControllerException {
        String r = CommandBuilder.transport("GetTransportInfo").put("InstanceID", "0").executeOn(this.ip);
        return PlayState.valueOf(ParserHelper.findOne("<CurrentTransportState>(.*)</CurrentTransportState>", r));
    }

    public void stop() throws IOException, SonosControllerException {
        CommandBuilder.transport("Stop").put("InstanceID", "0").put("Speed", "1").executeOn(this.ip);
    }

    public void seek(String time) throws IOException, SonosControllerException {
        CommandBuilder.transport("Seek").put("InstanceID", "0").put("Unit", "REL_TIME").put("Target", time).executeOn(this.ip);
    }

    public void seek(int time) throws IOException, SonosControllerException {
        this.seek(ParserHelper.secondsToFormatedTimestamp(time));
    }

    public void next() throws IOException, SonosControllerException {
        CommandBuilder.transport("Next").put("InstanceID", "0").put("Speed", "1").executeOn(this.ip);
    }

    public void previous() throws IOException, SonosControllerException {
        CommandBuilder.transport("Previous").put("InstanceID", "0").put("Speed", "1").executeOn(this.ip);
    }

    public void addToQueue(String uri, TrackMetadata metadata) throws IOException, SonosControllerException {
        String metadataString = "";
        if (metadata != null) {
            metadataString = metadata.toDIDL();
        }
        CommandBuilder.transport("AddURIToQueue").put("InstanceID", "0").put("EnqueuedURI", uri).put("EnqueuedURIMetaData", metadataString).put("DesiredFirstTrackNumberEnqueued", "0").put("EnqueueAsNext", "1").executeOn(this.ip);
    }

    public void addToQueue(int queueIndex, String uri, TrackMetadata metadata) throws IOException, SonosControllerException {
        String metadataString = "";
        if (metadata != null) {
            metadataString = metadata.toDIDL();
        }
        CommandBuilder.transport("AddURIToQueue").put("InstanceID", "0").put("EnqueuedURI", uri).put("EnqueuedURIMetaData", metadataString).put("DesiredFirstTrackNumberEnqueued", Integer.toString(queueIndex)).put("EnqueueAsNext", "0").executeOn(this.ip);
    }

    public void removeFromQueue(int queueIndex) throws IOException, SonosControllerException {
        if (queueIndex < 0) {
            throw new IllegalArgumentException("Queue index cannot be < 0.");
        }
        CommandBuilder.transport("RemoveTrackFromQueue").put("InstanceID", "0").put("ObjectID", "Q:0/" + queueIndex).put("UpdateID", "0").executeOn(this.ip);
    }

    public TrackInfo getCurrentTrackInfo() throws IOException, SonosControllerException {
        String r = CommandBuilder.transport("GetPositionInfo").put("InstanceID", "0").put("Channel", "Master").executeOn(this.ip);
        String track = ParserHelper.findOne("<Track>([0-9]*)</Track>", r);
        int trackNumber = -1;
        if (!track.equals("NOT_IMPLEMENTED") && !track.equals("")) {
            trackNumber = Integer.valueOf(track);
        }
        return new TrackInfo(trackNumber, ParserHelper.formatedTimestampToSeconds(ParserHelper.findOne("<TrackDuration>([0-9]*:[0-9]*:[0-9]*)</TrackDuration>", r)), ParserHelper.formatedTimestampToSeconds(ParserHelper.findOne("<RelTime>([0-9]*:[0-9]*:[0-9]*)</RelTime>", r)), ParserHelper.findOne("<TrackURI>(.*)</TrackURI>", r), TrackMetadata.parse(ParserHelper.findOne("<TrackMetaData>(.*)</TrackMetaData>", r)));
    }

    public PlayMode getPlayMode() throws IOException, SonosControllerException {
        String r = CommandBuilder.transport("GetTransportSettings").put("InstanceID", "0").executeOn(this.ip);
        return PlayMode.valueOf(ParserHelper.findOne("<PlayMode>(.*)</PlayMode>", r));
    }

    public void setPlayMode(PlayMode playMode) throws IOException, SonosControllerException {
        CommandBuilder.transport("SetPlayMode").put("InstanceID", "0").put("NewPlayMode", playMode.toString()).executeOn(this.ip);
    }

    public void clearQueue() throws IOException, SonosControllerException {
        CommandBuilder.transport("RemoveAllTracksFromQueue").put("InstanceID", "0").executeOn(this.ip);
    }

    public boolean isJoined() throws IOException, SonosControllerException {
        return this.getZoneGroupState().getZonePlayerUIDInGroup().size() > 1;
    }

    public List<SonosDevice> joinedWith() throws IOException, SonosControllerException {
        return this.getZoneGroupState().getSonosDevicesInGroup();
    }

    public void join(SonosDevice master) throws IOException, SonosControllerException {
        this.join(master.getSpeakerInfo().getLocalUID());
    }

    public void join(String masterUID) throws IOException, SonosControllerException {
        CommandBuilder.transport("SetAVTransportURI").put("InstanceID", "0").put("CurrentURI", "x-rincon:" + masterUID).put("CurrentURIMetaData", "").executeOn(this.ip);
    }

    public void unjoin() throws IOException, SonosControllerException {
        CommandBuilder.transport("BecomeCoordinatorOfStandaloneGroup").put("InstanceID", "0").put("Speed", "1").executeOn(this.ip);
    }

    public void switchToLineIn() throws IOException, SonosControllerException {
        String uid = this.getSpeakerInfo().getLocalUID();
        CommandBuilder.transport("SetAVTransportURI").put("InstanceID", "0").put("CurrentURI", "x-rincon-stream:" + uid).put("CurrentURIMetaData", "").executeOn(this.ip);
    }

    public void switchToTV() throws IOException, SonosControllerException {
        String uid = this.getSpeakerInfo().getLocalUID();
        CommandBuilder.transport("SetAVTransportURI").put("InstanceID", "0").put("CurrentURI", "x-sonos-htastream:" + uid + ":spdif").put("CurrentURIMetaData", "").executeOn(this.ip);
    }

    public int getVolume() throws IOException, SonosControllerException {
        String r = CommandBuilder.rendering("GetVolume").put("InstanceID", "0").put("Channel", "Master").executeOn(this.ip);
        return Integer.parseInt(ParserHelper.findOne("<CurrentVolume>([0-9]*)</CurrentVolume>", r));
    }

    public void setVolume(int volume) throws IOException, SonosControllerException {
        CommandBuilder.rendering("SetVolume").put("InstanceID", "0").put("Channel", "Master").put("DesiredVolume", String.valueOf(volume)).executeOn(this.ip);
    }

    public boolean isMuted() throws IOException, SonosControllerException {
        String r = CommandBuilder.rendering("GetMute").put("InstanceID", "0").put("Channel", "Master").executeOn(this.ip);
        return ParserHelper.findOne("<CurrentMute>([01])</CurrentMute>", r).equals("1");
    }

    public void setMute(boolean state) throws IOException, SonosControllerException {
        CommandBuilder.rendering("SetMute").put("InstanceID", "0").put("Channel", "Master").put("DesiredMute", state ? "1" : "0").executeOn(this.ip);
    }

    public void switchMute() throws IOException, SonosControllerException {
        this.setMute(!this.isMuted());
    }

    public int getBass() throws IOException, SonosControllerException {
        String r = CommandBuilder.rendering("GetBass").put("InstanceID", "0").put("Channel", "Master").executeOn(this.ip);
        return Integer.parseInt(ParserHelper.findOne("<CurrentBass>(.*)</CurrentBass>", r));
    }

    public void setBass(int bass) throws IOException, SonosControllerException {
        if (bass > 10 || bass < -10) {
            throw new IllegalArgumentException("Bass value need to be between 10 and -10");
        }
        CommandBuilder.rendering("SetBass").put("InstanceID", "0").put("DesiredBass", String.valueOf(bass)).executeOn(this.ip);
    }

    public boolean isLoudnessActivated() throws IOException, SonosControllerException {
        String r = CommandBuilder.rendering("GetLoudness").put("InstanceID", "0").put("Channel", "Master").executeOn(this.ip);
        return ParserHelper.findOne("<CurrentLoudness>(.*)</CurrentLoudness>", r).equals("1");
    }

    public void setLoudness(boolean loudness) throws IOException, SonosControllerException {
        CommandBuilder.rendering("SetLoudness").put("InstanceID", "0").put("Channel", "Master").put("DesiredLoudness", loudness ? "1" : "0").executeOn(this.ip);
    }

    public int getTreble() throws IOException, SonosControllerException {
        String r = CommandBuilder.rendering("GetTreble").put("InstanceID", "0").put("Channel", "Master").executeOn(this.ip);
        return Integer.parseInt(ParserHelper.findOne("<CurrentTreble>(.*)</CurrentTreble>", r));
    }

    public void setTreble(int treble) throws IOException, SonosControllerException {
        if (treble > 10 || treble < -10) {
            throw new IllegalArgumentException("treble value need to be between 10 and -10");
        }
        CommandBuilder.rendering("SetTreble").put("InstanceID", "0").put("DesiredTreble", String.valueOf(treble)).executeOn(this.ip);
    }

    public boolean isNightModeActivated() throws IOException, SonosControllerException {
        String s = CommandBuilder.rendering("GetEQ").put("InstanceID", "0").put("EQType", "NightMode").executeOn(this.ip);
        return ParserHelper.findOne("<CurrentValue>(.*)</CurrentValue>", s).equals("1");
    }

    public void setNightMode(boolean state) throws IOException, SonosControllerException {
        CommandBuilder.rendering("SetEQ").put("InstanceID", "0").put("EQType", "NightMode").put("DesiredValue", state ? "1" : "0").executeOn(this.ip);
    }

    public void switchNightMode() throws IOException, SonosControllerException {
        this.setNightMode(!this.isNightModeActivated());
    }

    public boolean isDialogModeActivated() throws IOException, SonosControllerException {
        String s = CommandBuilder.rendering("GetEQ").put("InstanceID", "0").put("EQType", "DialogLevel").executeOn(this.ip);
        return ParserHelper.findOne("<CurrentValue>(.*)</CurrentValue>", s).equals("1");
    }

    public void setDialogMode(boolean state) throws IOException, SonosControllerException {
        CommandBuilder.rendering("SetEQ").put("InstanceID", "0").put("EQType", "DialogLevel").put("DesiredValue", state ? "1" : "0").executeOn(this.ip);
    }

    public void switchDialogMode() throws IOException, SonosControllerException {
        this.setDialogMode(!this.isDialogModeActivated());
    }

    public String getZoneName() throws IOException, SonosControllerException {
        return this.getZoneGroupState().getName();
    }

    public String getRoomNameCached() {
        if (this.roomName == null) {
            try {
                this.getRoomName();
            }
            catch (SonosControllerException | IOException e) {
                LOGGER.severe(MessageFormat.format("Could not retrieve the room name of the device: {0}", e));
            }
        }
        return this.roomName;
    }

    public String getRoomName() throws IOException, SonosControllerException {
        String roomName;
        String r = CommandBuilder.download(this.ip, "xml/device_description.xml");
        r = Pattern.compile("<deviceList>.*</deviceList>", 32).matcher(r).replaceFirst("");
        this.roomName = roomName = ParserHelper.findOne("<roomName>(.*)</roomName>", r);
        return roomName;
    }

    public String getDeviceNameCached() {
        if (this.deviceName == null) {
            try {
                this.getDeviceName();
            }
            catch (SonosControllerException | IOException e) {
                LOGGER.severe(MessageFormat.format("Could not retrieve the device name: {0}", e));
            }
        }
        return this.deviceName;
    }

    public String getDeviceName() throws IOException, SonosControllerException {
        String deviceName;
        this.deviceName = deviceName = this.getSpeakerInfo().getDeviceName();
        return deviceName;
    }

    public void setRoomName(String roomName) throws IOException, SonosControllerException {
        CommandBuilder.device("SetZoneAttributes").put("DesiredZoneName", roomName).put("DesiredIcon", "").put("DesiredConfiguration", "").executeOn(this.ip);
        this.roomName = roomName;
    }

    public boolean getLedState() throws IOException, SonosControllerException {
        String r = CommandBuilder.device("GetLEDState").executeOn(this.ip);
        return ParserHelper.findOne("<CurrentLEDState>(.*)</CurrentLEDState>", r).equals("On");
    }

    public void setLedState(boolean state) throws IOException, SonosControllerException {
        CommandBuilder.device("SetLEDState").put("DesiredLEDState", state ? "On" : "Off").executeOn(this.ip);
    }

    public void switchLedState() throws IOException, SonosControllerException {
        this.setLedState(!this.getLedState());
    }

    public List<TrackMetadata> getQueue(int startingIndex, int requestedCount) throws IOException, SonosControllerException {
        String r = CommandBuilder.contentDirectory("Browse").put("ObjectID", "Q:0").put("BrowseFlag", "BrowseDirectChildren").put("Filter", "dc:title,res,dc:creator,upnp:artist,upnp:album,upnp:albumArtURI").put("StartingIndex", String.valueOf(startingIndex)).put("RequestedCount", String.valueOf(requestedCount)).put("SortCriteria", "").executeOn(this.ip);
        List<String> itemsNonParsed = ParserHelper.findAll("<item .+?(?=>)>(.+?(?=</item>))", r);
        ArrayList<TrackMetadata> itemsParsed = new ArrayList<TrackMetadata>();
        for (String s : itemsNonParsed) {
            itemsParsed.add(TrackMetadata.parse(s));
        }
        return itemsParsed;
    }

    public SonosZoneInfo getZoneGroupState() throws IOException, SonosControllerException {
        String r = CommandBuilder.zoneGroupTopology("GetZoneGroupAttributes").executeOn(this.ip);
        String name = ParserHelper.findOne("<CurrentZoneGroupName>(.*)</CurrentZoneGroupName>", r);
        String id = ParserHelper.findOne("<CurrentZoneGroupID>(.*)</CurrentZoneGroupID>", r);
        String devices = ParserHelper.findOne("<CurrentZonePlayerUUIDsInGroup>(.*)</CurrentZonePlayerUUIDsInGroup>", r);
        List<String> deviceList = Arrays.asList(devices.split(","));
        return new SonosZoneInfo(name, id, deviceList);
    }

    public boolean isCoordinator() throws IOException, SonosControllerException {
        String uid = this.getSpeakerInfo().getLocalUID();
        return this.getZoneGroupState().getId().startsWith(uid);
    }

    public SonosSpeakerInfo getSpeakerInfo() throws IOException, SonosControllerException {
        String responseString = CommandBuilder.download(this.ip, "status/zp");
        String deviceName = ParserHelper.findOne("<ZoneName>(.*)</ZoneName>", responseString);
        String zoneIcon = ParserHelper.findOne("<ZoneIcon>(.*)</ZoneIcon>", responseString);
        String configuration = ParserHelper.findOne("<Configuration>(.*)</Configuration>", responseString);
        String localUID = ParserHelper.findOne("<LocalUID>(.*)</LocalUID>", responseString);
        String serialNumber = ParserHelper.findOne("<SerialNumber>(.*)</SerialNumber>", responseString);
        String softwareVersion = ParserHelper.findOne("<SoftwareVersion>(.*)</SoftwareVersion>", responseString);
        String softwareDate = ParserHelper.findOne("<SoftwareDate>(.*)</SoftwareDate>", responseString);
        String softwareScm = ParserHelper.findOne("<SoftwareScm>(.*)</SoftwareScm>", responseString);
        String minCompatibleVersion = ParserHelper.findOne("<MinCompatibleVersion>(.*)</MinCompatibleVersion>", responseString);
        String legacyCompatibleVersion = ParserHelper.findOne("<LegacyCompatibleVersion>(.*)</LegacyCompatibleVersion>", responseString);
        String hardwareVersion = ParserHelper.findOne("<HardwareVersion>(.*)</HardwareVersion>", responseString);
        String dspVersion = ParserHelper.findOne("<DspVersion>(.*)</DspVersion>", responseString);
        String hwFlags = ParserHelper.findOne("<HwFlags>(.*)</HwFlags>", responseString);
        String hwFeatures = ParserHelper.findOne("<HwFeatures>(.*)</HwFeatures>", responseString);
        String variant = ParserHelper.findOne("<Variant>(.*)</Variant>", responseString);
        String generalFlags = ParserHelper.findOne("<GeneralFlags>(.*)</GeneralFlags>", responseString);
        String ipAddress = ParserHelper.findOne("<IPAddress>(.*)</IPAddress>", responseString);
        String macAddress = ParserHelper.findOne("<MACAddress>(.*)</MACAddress>", responseString);
        String copyright = ParserHelper.findOne("<Copyright>(.*)</Copyright>", responseString);
        String extraInfo = ParserHelper.findOne("<ExtraInfo>(.*)</ExtraInfo>", responseString);
        String htAudioInCode = ParserHelper.findOne("<HTAudioInCode>(.*)</HTAudioInCode>", responseString);
        String idxTrk = ParserHelper.findOne("<IdxTrk>(.*)</IdxTrk>", responseString);
        String mdp2Ver = ParserHelper.findOne("<MDP2Ver>(.*)</MDP2Ver>", responseString);
        String mdp3Ver = ParserHelper.findOne("<MDP3Ver>(.*)</MDP3Ver>", responseString);
        String relBuild = ParserHelper.findOne("<RelBuild>(.*)</RelBuild>", responseString);
        String whitelistBuild = ParserHelper.findOne("<WhitelistBuild>(.*)</WhitelistBuild>", responseString);
        String prodUnit = ParserHelper.findOne("<ProdUnit>(.*)</ProdUnit>", responseString);
        String fuseCfg = ParserHelper.findOne("<FuseCfg>(.*)</FuseCfg>", responseString);
        String revokeFuse = ParserHelper.findOne("<RevokeFuse>(.*)</RevokeFuse>", responseString);
        String authFlags = ParserHelper.findOne("<AuthFlags>(.*)</AuthFlags>", responseString);
        String swFeatures = ParserHelper.findOne("<SwFeatures>(.*)</SwFeatures>", responseString);
        String regState = ParserHelper.findOne("<RegState>(.*)</RegState>", responseString);
        String customerID = ParserHelper.findOne("<CustomerID>(.*)</CustomerID>", responseString);
        return new SonosSpeakerInfo(deviceName, zoneIcon, configuration, localUID, serialNumber, softwareVersion, softwareDate, softwareScm, minCompatibleVersion, legacyCompatibleVersion, hardwareVersion, dspVersion, hwFlags, hwFeatures, variant, generalFlags, ipAddress, macAddress, copyright, extraInfo, htAudioInCode, idxTrk, mdp2Ver, mdp3Ver, relBuild, whitelistBuild, prodUnit, fuseCfg, revokeFuse, authFlags, swFeatures, regState, customerID);
    }

    public String toString() {
        return "SonosDevice{ip='" + this.ip + "' name='" + this.getDeviceNameCached() + "'}";
    }

    public boolean registerSonosEventListener(SonosEventListener eventHandler) {
        if (!this.sonosEventHandlers.contains(eventHandler)) {
            boolean sucess = this.sonosEventHandlers.add(eventHandler);
            if (!this.uPnPSubscribed) {
                this.subscribeToUPnPEvents();
            }
            return sucess;
        }
        LOGGER.fine(MessageFormat.format("Event listener {0} already registered", eventHandler));
        return false;
    }

    public boolean unregisterSonosEventListener(SonosEventListener eventHandler) {
        if (this.sonosEventHandlers.contains(eventHandler)) {
            this.sonosEventHandlers.remove(eventHandler);
            if (this.sonosEventHandlers.size() == 0 && this.uPnPSubscribed) {
                this.unsubscribeUPnPEvents();
            }
            return true;
        }
        LOGGER.fine(MessageFormat.format("Trying to remove event listener {0} but it's not registered", eventHandler));
        return false;
    }

    @Deprecated
    public UPnPDevice getUPnPDevice() {
        return this.uPnPDevice;
    }

    private void subscribeToUPnPEvents() {
        try {
            this.eventSubscriptions.add(this.uPnPDevice.subscribe(new RenderingControlListener(MEDIA_RENDERER_CONTROL_EVENT_ENDPOINT, this), MEDIA_RENDERER_CONTROL_EVENT_ENDPOINT));
            this.eventSubscriptions.add(this.uPnPDevice.subscribe(new AVTTransportListener(MEDIA_RENDERER_AVTRANSPORT_EVENT_ENDPOINT, this), MEDIA_RENDERER_AVTRANSPORT_EVENT_ENDPOINT));
            this.eventSubscriptions.add(this.uPnPDevice.subscribe(new MediaRendererQueueListener(MEDIA_RENDERER_QUEUE_EVENT_ENDPOINT, this), MEDIA_RENDERER_QUEUE_EVENT_ENDPOINT));
            this.eventSubscriptions.add(this.uPnPDevice.subscribe(new ZoneTopologyListener(ZONE_GROUP_TOPOLOGY_EVENT_ENDPOINT, this), ZONE_GROUP_TOPOLOGY_EVENT_ENDPOINT));
            this.uPnPSubscribed = true;
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    private void unsubscribeUPnPEvents() {
        ListIterator<String> eventKeys = this.eventSubscriptions.listIterator();
        while (eventKeys.hasNext()) {
            String sid = eventKeys.next();
            if (this.uPnPDevice.unsubscribeFromToken(sid)) {
                eventKeys.remove();
                continue;
            }
            LOGGER.warning("Could not unsubscreibe from " + sid);
        }
        this.uPnPSubscribed = false;
    }

    public List<SonosEventListener> getEventListener() {
        return this.sonosEventHandlers;
    }

    public String resolveAlbumURL(String baseURL) {
        return "http://" + this.ip + ":1400" + baseURL;
    }

    public void deinit() {
        this.uPnPDevice.deinit();
    }
}

