/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.apis.googleTextToSpeech;

import com.github.kilianB.apis.googleTextToSpeech.GLanguage;
import com.github.kilianB.apis.googleTextToSpeech.GoogleTextToSpeechObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public class GoogleTextToSpeech {
    private static final Logger LOGGER = Logger.getLogger(GoogleTextToSpeech.class.getName());
    private static final AtomicInteger convertId = new AtomicInteger(0);
    private static final int BITS_PER_DATA_BLOCK = 736;
    private static final int BITS_PER_HEADER_BLOCK = 32;
    private static final byte[] MP3_HEADER = new byte[]{-1, -13, 68, -60};
    private final String GOOGLE_URL = "https://translate.google.com/translate_tts?ie=UTF-8&client=tw-ob&q=__TEXT__&tl=";
    private GLanguage defaultLanguage = GLanguage.English_GB;
    private int characterLimit = 200;
    private String outputDirectoryPath;
    private int mismatchBlockThreshold = 12;
    private long msSleepBetweenRequests = 50L;
    private static boolean bufferCleanStrategyUnsafe = true;
    private static Unsafe unsafe;

    public GoogleTextToSpeech(String outputDirectoryPath) {
        this.outputDirectoryPath = outputDirectoryPath;
    }

    public File convertText(String text, String outputFileName) {
        return this.convertText(text, this.defaultLanguage, outputFileName);
    }

    public File convertText(String text, GLanguage language, String outputFileName) {
        ArrayList<File> tempFiles = new ArrayList<File>();
        this.convertText(new String[]{text}, new GLanguage[]{language}, outputFileName, tempFiles, null);
        return this.mergeFiles(outputFileName, true, tempFiles.toArray(new File[tempFiles.size()]));
    }

    public File convertTextMultiLanguage(String[] text, GLanguage[] language, String outputFileName) {
        ArrayList<File> tempFiles = new ArrayList<File>();
        this.convertText(text, language, outputFileName, tempFiles, null);
        return this.mergeFiles(outputFileName, true, tempFiles.toArray(new File[tempFiles.size()]));
    }

    public void convertTextAsynch(String text, GLanguage language, String outputFilePath, boolean deleteTempFiles, GoogleTextToSpeechObserver observer) {
        this.convertTextMultiLanguageAsynch(new String[]{text}, new GLanguage[]{language}, outputFilePath, deleteTempFiles, observer);
    }

    public void convertTextMultiLanguageAsynch(String[] text, GLanguage[] language, String outoutFilePath, boolean deleteTempFiles, GoogleTextToSpeechObserver observer) {
        new Thread(() -> {
            ArrayList<File> tempFiles = new ArrayList<File>();
            int id = this.convertText(text, language, outoutFilePath, tempFiles, observer);
            File mergedFile = this.mergeFiles(outoutFilePath, deleteTempFiles, tempFiles.toArray(new File[tempFiles.size()]));
            if (observer != null) {
                observer.mergeCompleted(mergedFile, id);
            }
        }).start();
    }

    private int convertText(String[] text, GLanguage[] language, final String outputFilePrefix, ArrayList<File> temporaryFiles, GoogleTextToSpeechObserver observer) {
        int i;
        int identifier = convertId.incrementAndGet();
        ArrayList<RequestData> requestData = new ArrayList<RequestData>();
        for (int j = 0; j < text.length; ++j) {
            String[] sentences = text[j].split("\\.");
            ArrayList<String> requestStrings = new ArrayList<String>();
            Object tempRequest = "";
            for (i = 0; i < sentences.length; ++i) {
                if (((String)tempRequest).length() + sentences[i].length() > this.characterLimit) {
                    if (!((String)tempRequest).isEmpty()) {
                        requestStrings.add((String)tempRequest);
                    }
                    tempRequest = sentences[i] + ".";
                } else {
                    tempRequest = (String)tempRequest + sentences[i] + ".";
                }
                while (((String)tempRequest).length() > this.characterLimit) {
                    int wordEndIndex = ((String)tempRequest).lastIndexOf(" ", this.characterLimit);
                    String subsentence = ((String)tempRequest).substring(0, wordEndIndex);
                    requestStrings.add(subsentence);
                    tempRequest = ((String)tempRequest).substring(wordEndIndex);
                }
            }
            if (((String)tempRequest).length() > 0) {
                requestStrings.add((String)tempRequest);
            }
            if (j >= language.length) {
                requestData.add(new RequestData(this.defaultLanguage, requestStrings));
                continue;
            }
            requestData.add(new RequestData(language[j], requestStrings));
        }
        try {
            int requestWrapperCount = requestData.size();
            ExecutorService threadPool = Executors.newFixedThreadPool(10);
            ArrayList callback = new ArrayList();
            int fileNamingOffset = 0;
            for (int j = 0; j < requestWrapperCount; ++j) {
                final ArrayList<String> requests = ((RequestData)requestData.get((int)j)).requests;
                final GLanguage requestLanguage = ((RequestData)requestData.get((int)j)).language;
                int requestCount = requests.size();
                for (int i2 = 0; i2 < requestCount; ++i2) {
                    Callable task = (new Callable<File>(){
                        int i;
                        int fileNamingOffset;

                        private Callable<File> setParameters(int i, int fileNamingOffset) {
                            this.i = i;
                            this.fileNamingOffset = fileNamingOffset;
                            return this;
                        }

                        @Override
                        public File call() throws Exception {
                            int len;
                            String query = URLEncoder.encode((String)requests.get(this.i), "UTF-8");
                            String request = "https://translate.google.com/translate_tts?ie=UTF-8&client=tw-ob&q=__TEXT__&tl=".replace("__TEXT__", query) + requestLanguage.getCountryCode();
                            HttpURLConnection conn = (HttpURLConnection)new URL(request).openConnection();
                            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
                            InputStream is = conn.getInputStream();
                            File outputFile = new File(GoogleTextToSpeech.this.outputDirectoryPath + outputFilePrefix + (this.i + this.fileNamingOffset) + ".mp3");
                            FileOutputStream outstream = new FileOutputStream(outputFile);
                            byte[] buffer = new byte[4096];
                            while ((len = is.read(buffer)) > 0) {
                                ((OutputStream)outstream).write(buffer, 0, len);
                            }
                            is.close();
                            ((OutputStream)outstream).close();
                            conn.disconnect();
                            return outputFile;
                        }
                    }).setParameters(i2, fileNamingOffset);
                    Future future = threadPool.submit(task);
                    callback.add(future);
                    Thread.sleep(this.msSleepBetweenRequests);
                }
                fileNamingOffset += requestCount;
            }
            for (i = 0; i < callback.size(); ++i) {
                File tempFile = (File)((Future)callback.get(i)).get();
                if (observer != null) {
                    if (i == 0 && fileNamingOffset == 0) {
                        observer.firstFileDownloaded(tempFile, identifier);
                    }
                    observer.fileDownloaded(tempFile, identifier);
                }
                temporaryFiles.add(tempFile);
            }
            threadPool.shutdownNow();
            if (observer != null) {
                observer.fileDownloadCompleted(identifier);
            }
            return identifier;
        }
        catch (Exception e) {
            e.printStackTrace();
            return identifier;
        }
    }

    private File mergeFiles(String targetName, boolean deleteOldFiles, File ... filesToMerge) {
        File targetFile = new File(this.outputDirectoryPath + targetName + ".mp3");
        if (targetFile.exists()) {
            targetFile.delete();
        }
        try {
            targetFile.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(targetFile);
            int SIZE = 4000;
            for (int i = 0; i < filesToMerge.length; ++i) {
                FileInputStream fileInputStream = new FileInputStream(filesToMerge[i]);
                FileChannel fileChannel = fileInputStream.getChannel();
                MappedByteBuffer mb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
                byte[] barray = new byte[SIZE];
                boolean done = false;
                int byteCount = 96;
                int truncateBlocksAtEndOfFile = 0;
                truncateBlocksAtEndOfFile = 0;
                while (true) {
                    byte[] bArray = new byte[byteCount];
                    mb.position((int)fileChannel.size() - byteCount * (truncateBlocksAtEndOfFile + 1));
                    mb.get(bArray, 0, byteCount);
                    if (!Arrays.equals(bArray, 0, 4, MP3_HEADER, 0, 4)) {
                        LOGGER.warning("Expected mp3 header block but didn't find it");
                    }
                    int dataStart = MP3_HEADER.length + 12;
                    boolean mismatchBlock = false;
                    int mismatch = 0;
                    for (int j = dataStart; j < byteCount; ++j) {
                        if (bArray[j] == 85 || bArray[j] == -86 || ++mismatch < this.mismatchBlockThreshold) continue;
                        mismatchBlock = true;
                        break;
                    }
                    if (mismatchBlock) break;
                    ++truncateBlocksAtEndOfFile;
                }
                int bytesToTruncate = truncateBlocksAtEndOfFile * 96;
                mb.position(0);
                while (!done && mb.hasRemaining()) {
                    int nGet = Math.min(mb.remaining(), SIZE);
                    if (nGet > mb.remaining() - bytesToTruncate) {
                        nGet = mb.remaining() - bytesToTruncate;
                        done = true;
                    }
                    barray = new byte[nGet];
                    mb.get(barray, 0, nGet);
                    fileOutputStream.write(barray);
                }
                fileInputStream.close();
                fileChannel.close();
                if (unsafe != null) {
                    unsafe.invokeCleaner(mb);
                    continue;
                }
                mb = null;
                System.gc();
            }
            fileOutputStream.close();
            if (deleteOldFiles) {
                for (File f : filesToMerge) {
                    f.delete();
                }
            }
            return targetFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private long findClosestDivisibleInteger(long dividend, long divisor) {
        long lowerBound = dividend - dividend % divisor;
        long upperBound = dividend + divisor - dividend % divisor;
        if (dividend - lowerBound > upperBound - dividend) {
            return upperBound;
        }
        return lowerBound;
    }

    static {
        if (bufferCleanStrategyUnsafe) {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                unsafe = (Unsafe)f.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    private class RequestData {
        GLanguage language;
        ArrayList<String> requests;

        public RequestData(GLanguage language, ArrayList<String> requests) {
            this.language = language;
            this.requests = requests;
        }
    }
}

