/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.gradle.plugins;

import fr.brouillard.oss.gradle.plugins.JGitverPluginExtension;
import fr.brouillard.oss.gradle.plugins.JGitverPluginExtensionBranchPolicy;
import fr.brouillard.oss.gradle.plugins.JGitverVersionTask;
import fr.brouillard.oss.jgitver.BranchingPolicy;
import fr.brouillard.oss.jgitver.GitVersionCalculator;
import fr.brouillard.oss.jgitver.Strategies;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.tooling.BuildException;

public class JGitverPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getExtensions().create("jgitver", JGitverPluginExtension.class, new Object[]{project});
        project.getTasks().create("version", JGitverVersionTask.class);
        project.afterEvaluate((Action)new Action<Project>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Project evaluatedProject) {
                JGitverPluginExtension jgitverConfiguration = (JGitverPluginExtension)project.getExtensions().findByType(JGitverPluginExtension.class);
                Optional<String> oldDistanceKindSystemProperty = Optional.ofNullable(jgitverConfiguration.distanceCalculatorKind).map(kind -> System.setProperty("jgitver.calculator.kind", kind.name()));
                try {
                    GitVersionCalculator versionCalculator = GitVersionCalculator.location((File)project.getRootDir());
                    if (Boolean.TRUE.equals(jgitverConfiguration.mavenLike)) {
                        project.getLogger().info("usage of deprecated 'mavenLike' parameter takes precedence over 'strategy: {}'", (Object)jgitverConfiguration.strategy);
                        versionCalculator.setStrategy(Strategies.MAVEN);
                    } else {
                        versionCalculator.setStrategy(jgitverConfiguration.strategy);
                    }
                    if (jgitverConfiguration.policy != null) {
                        versionCalculator.setLookupPolicy(jgitverConfiguration.policy);
                    }
                    versionCalculator.setMaxDepth(jgitverConfiguration.maxDepth).setAutoIncrementPatch(jgitverConfiguration.autoIncrementPatch.booleanValue()).setUseDistance(jgitverConfiguration.useDistance.booleanValue()).setUseDirty(jgitverConfiguration.useDirty.booleanValue()).setUseGitCommitTimestamp(jgitverConfiguration.useGitCommitTimestamp.booleanValue()).setUseGitCommitId(jgitverConfiguration.useGitCommitID.booleanValue()).setGitCommitIdLength(jgitverConfiguration.gitCommitIDLength).setVersionPattern(jgitverConfiguration.versionPattern).setTagVersionPattern(jgitverConfiguration.tagVersionPattern).setNonQualifierBranches(jgitverConfiguration.nonQualifierBranches);
                    if (!jgitverConfiguration.policies.isEmpty()) {
                        List branchingPolicies = jgitverConfiguration.policies.stream().map(x$0 -> JGitverPlugin.toBranchingPolicy(x$0)).collect(Collectors.toList());
                        versionCalculator.setQualifierBranchingPolicies(branchingPolicies);
                    }
                    if (jgitverConfiguration.regexVersionTag != null) {
                        versionCalculator = versionCalculator.setFindTagVersionPattern(jgitverConfiguration.regexVersionTag);
                    }
                    String gitCalculatedVersion = versionCalculator.getVersion();
                    boolean isDirty = versionCalculator.meta(Metadatas.DIRTY).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
                    if (jgitverConfiguration.useDirty.booleanValue() && jgitverConfiguration.failIfDirty.booleanValue() && isDirty) {
                        IllegalStateException cause = new IllegalStateException("jgitver detected a dirty state, project is configured to fail");
                        throw new BuildException("jgitver stopped the build for a git dirty state", (Throwable)cause);
                    }
                    project.setVersion((Object)gitCalculatedVersion);
                    project.getAllprojects().forEach(subproject -> subproject.setVersion((Object)gitCalculatedVersion));
                    for (Metadatas metadata : Metadatas.values()) {
                        versionCalculator.meta(metadata).ifPresent(metadataValue -> {
                            project.getExtensions().getExtraProperties().set(metadata.name().toLowerCase(Locale.ENGLISH), metadataValue);
                            project.getAllprojects().forEach(subproject -> subproject.getExtensions().getExtraProperties().set(metadata.name().toLowerCase(Locale.ENGLISH), metadataValue));
                        });
                    }
                }
                finally {
                    oldDistanceKindSystemProperty.ifPresent(oldVAlue -> System.setProperty("jgitver.calculator.kind", oldVAlue));
                }
            }
        });
    }

    private static BranchingPolicy toBranchingPolicy(JGitverPluginExtensionBranchPolicy gradleBranchPolicy) {
        return new BranchingPolicy(gradleBranchPolicy.pattern, gradleBranchPolicy.transformations);
    }
}

