/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest;

import fr.bmartel.speedtest.RepeatWrapper;
import fr.bmartel.speedtest.SpeedTestConst;
import fr.bmartel.speedtest.SpeedTestReport;
import fr.bmartel.speedtest.SpeedTestTask;
import fr.bmartel.speedtest.inter.IRepeatListener;
import fr.bmartel.speedtest.inter.ISpeedTestListener;
import fr.bmartel.speedtest.inter.ISpeedTestSocket;
import fr.bmartel.speedtest.model.ComputationMethod;
import fr.bmartel.speedtest.model.SpeedTestMode;
import fr.bmartel.speedtest.model.UploadStorageType;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SpeedTestSocket
implements ISpeedTestSocket {
    private int mScale = 4;
    private RoundingMode mRoundingMode = SpeedTestConst.DEFAULT_ROUNDING_MODE;
    private UploadStorageType mUploadStorageType = UploadStorageType.RAM_STORAGE;
    private final List<ISpeedTestListener> mListenerList = new ArrayList<ISpeedTestListener>();
    private int mUploadChunkSize = 65535;
    private int mSocketTimeout = 10000;
    private final RepeatWrapper mRepeatWrapper = new RepeatWrapper(this);
    private final SpeedTestTask mTask = new SpeedTestTask(this, this.mListenerList);
    private long mDownloadSetupTime = 0L;
    private long mUploadSetupTime = 0L;
    private int mReportInterval = -1;
    private ComputationMethod mComputationMethod = ComputationMethod.MEDIAN_ALL_TIME;
    private static final int DEFAULT_REPEAT_INTERVAL = 1000;

    public SpeedTestSocket() {
    }

    public SpeedTestSocket(int reportInterval) {
        this.mReportInterval = reportInterval;
    }

    private void initReportTask(int reportInterval) {
        this.mTask.renewReportThreadPool();
        this.mTask.getReportThreadPool().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SpeedTestReport report = SpeedTestSocket.this.getLiveReport();
                for (ISpeedTestListener listener : SpeedTestSocket.this.mListenerList) {
                    listener.onProgress(report.getProgressPercent(), report);
                }
            }
        }, reportInterval, reportInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void addSpeedTestListener(ISpeedTestListener listener) {
        this.mListenerList.add(listener);
    }

    @Override
    public void removeSpeedTestListener(ISpeedTestListener listener) {
        this.mListenerList.remove(listener);
    }

    @Override
    public void shutdownAndWait() {
        this.mTask.shutdownAndWait();
    }

    public void startFixedDownload(String uri, int maxDuration) {
        if (this.mReportInterval != -1 && !this.mTask.isReportInterval()) {
            this.initReportTask(this.mReportInterval);
            this.mTask.setReportInterval(true);
        }
        this.mTask.renewReportThreadPool();
        this.mTask.getReportThreadPool().schedule(new Runnable(){

            @Override
            public void run() {
                SpeedTestSocket.this.forceStopTask();
            }
        }, (long)maxDuration, TimeUnit.MILLISECONDS);
        this.startDownload(uri);
    }

    public void startFixedDownload(String uri, int maxDuration, int reportInterval) {
        this.initReportTask(reportInterval);
        this.mTask.setReportInterval(true);
        this.startFixedDownload(uri, maxDuration);
    }

    public void startDownload(String uri, int reportInterval) {
        this.initReportTask(reportInterval);
        this.mTask.setReportInterval(true);
        this.startDownload(uri);
    }

    @Override
    public void startDownload(String uri) {
        if (this.mReportInterval != -1 && !this.mTask.isReportInterval()) {
            this.initReportTask(this.mReportInterval);
            this.mTask.setReportInterval(true);
        }
        this.mTask.startDownloadRequest(uri);
    }

    public void startFixedUpload(String uri, int fileSizeOctet, int maxDuration) {
        if (this.mReportInterval != -1 && !this.mTask.isReportInterval()) {
            this.initReportTask(this.mReportInterval);
            this.mTask.setReportInterval(true);
        }
        this.mTask.renewReportThreadPool();
        this.mTask.getReportThreadPool().schedule(new Runnable(){

            @Override
            public void run() {
                SpeedTestSocket.this.forceStopTask();
            }
        }, (long)maxDuration, TimeUnit.MILLISECONDS);
        this.startUpload(uri, fileSizeOctet);
    }

    public void startFixedUpload(String uri, int fileSizeOctet, int maxDuration, int reportInterval) {
        this.initReportTask(reportInterval);
        this.mTask.setReportInterval(true);
        this.startFixedUpload(uri, fileSizeOctet, maxDuration);
    }

    public void startUpload(String uri, int fileSizeOctet, int reportInterval) {
        this.initReportTask(reportInterval);
        this.mTask.setReportInterval(true);
        this.startUpload(uri, fileSizeOctet);
    }

    @Override
    public void startUpload(String uri, int fileSizeOctet) {
        if (this.mReportInterval != -1 && !this.mTask.isReportInterval()) {
            this.initReportTask(this.mReportInterval);
            this.mTask.setReportInterval(true);
        }
        this.mTask.startUploadRequest(uri, fileSizeOctet);
    }

    public void startDownloadRepeat(String uri, int repeatWindow, IRepeatListener repeatListener) {
        int reportPeriodMillis = this.mReportInterval != -1 ? this.mReportInterval : 1000;
        this.startDownloadRepeat(uri, repeatWindow, reportPeriodMillis, repeatListener);
    }

    public void startDownloadRepeat(String uri, int repeatWindow, int reportPeriodMillis, IRepeatListener repeatListener) {
        this.mRepeatWrapper.startDownloadRepeat(uri, repeatWindow, reportPeriodMillis, repeatListener);
    }

    public void startUploadRepeat(String uri, int repeatWindow, int fileSizeOctet, IRepeatListener repeatListener) {
        int reportPeriodMillis = this.mReportInterval != -1 ? this.mReportInterval : 1000;
        this.startUploadRepeat(uri, repeatWindow, reportPeriodMillis, fileSizeOctet, repeatListener);
    }

    public void startUploadRepeat(String uri, int repeatWindow, int reportPeriodMillis, int fileSizeOctet, IRepeatListener repeatListener) {
        this.mRepeatWrapper.startUploadRepeat(uri, repeatWindow, reportPeriodMillis, fileSizeOctet, repeatListener);
    }

    @Override
    public void forceStopTask() {
        this.mRepeatWrapper.cleanTimer();
        this.mTask.forceStopTask();
        this.mTask.closeSocket();
        this.shutdownAndWait();
    }

    @Override
    public SpeedTestReport getLiveReport() {
        if (this.getSpeedTestMode() == SpeedTestMode.DOWNLOAD) {
            return this.mTask.getReport(SpeedTestMode.DOWNLOAD);
        }
        return this.mTask.getReport(SpeedTestMode.UPLOAD);
    }

    @Override
    public void closeSocket() {
        this.mTask.closeSocket();
    }

    public SpeedTestMode getSpeedTestMode() {
        return this.mTask.getSpeedTestMode();
    }

    public void setSocketTimeout(int socketTimeoutMillis) {
        if (socketTimeoutMillis >= 0) {
            this.mSocketTimeout = socketTimeoutMillis;
        }
    }

    @Override
    public int getSocketTimeout() {
        return this.mSocketTimeout;
    }

    @Override
    public int getUploadChunkSize() {
        return this.mUploadChunkSize;
    }

    @Override
    public RepeatWrapper getRepeatWrapper() {
        return this.mRepeatWrapper;
    }

    public void setUploadChunkSize(int uploadChunkSize) {
        this.mUploadChunkSize = uploadChunkSize;
    }

    public void setDefaultRoundingMode(RoundingMode roundingMode) {
        this.mRoundingMode = roundingMode;
    }

    public void setDefaultScale(int scale) {
        this.mScale = scale;
    }

    @Override
    public void setComputationMethod(ComputationMethod computationMethod) {
        this.mComputationMethod = computationMethod;
    }

    @Override
    public ComputationMethod getComputationMethod() {
        return this.mComputationMethod;
    }

    public void setUploadSetupTime(long setupTime) {
        this.mUploadSetupTime = setupTime;
    }

    public void setDownloadSetupTime(long setupTime) {
        this.mDownloadSetupTime = setupTime;
    }

    @Override
    public long getDownloadSetupTime() {
        return this.mDownloadSetupTime;
    }

    @Override
    public long getUploadSetupTime() {
        return this.mUploadSetupTime;
    }

    @Override
    public RoundingMode getDefaultRoundingMode() {
        return this.mRoundingMode;
    }

    @Override
    public int getDefaultScale() {
        return this.mScale;
    }

    @Override
    public UploadStorageType getUploadStorageType() {
        return this.mUploadStorageType;
    }

    @Override
    public void setUploadStorageType(UploadStorageType uploadStorageType) {
        this.mUploadStorageType = uploadStorageType;
    }

    public void clearListeners() {
        this.mListenerList.clear();
    }
}

