/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.model;

import com.facebook.FacebookGraphObjectException;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.CreateGraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.model.JsonUtil;
import com.facebook.model.PropertyName;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public interface GraphObject {
    public <T extends GraphObject> T cast(Class<T> var1);

    public Map<String, Object> asMap();

    public JSONObject getInnerJSONObject();

    public Object getProperty(String var1);

    public <T extends GraphObject> T getPropertyAs(String var1, Class<T> var2);

    public <T extends GraphObject> GraphObjectList<T> getPropertyAsList(String var1, Class<T> var2);

    public void setProperty(String var1, Object var2);

    public void removeProperty(String var1);

    public static final class Factory {
        private static final HashSet<Class<?>> verifiedGraphObjectClasses = new HashSet();
        private static final SimpleDateFormat[] dateFormats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US), new SimpleDateFormat("yyyy-MM-dd", Locale.US)};

        private Factory() {
        }

        public static GraphObject create(JSONObject json) {
            return Factory.create(json, GraphObject.class);
        }

        public static <T extends GraphObject> T create(JSONObject json, Class<T> graphObjectClass) {
            return Factory.createGraphObjectProxy(graphObjectClass, json);
        }

        public static GraphObject create() {
            return Factory.create(GraphObject.class);
        }

        public static <T extends GraphObject> T create(Class<T> graphObjectClass) {
            return Factory.createGraphObjectProxy(graphObjectClass, new JSONObject());
        }

        public static boolean hasSameId(GraphObject a, GraphObject b) {
            if (a == null || b == null || !a.asMap().containsKey("id") || !b.asMap().containsKey("id")) {
                return false;
            }
            if (a.equals(b)) {
                return true;
            }
            Object idA = a.getProperty("id");
            Object idB = b.getProperty("id");
            if (idA == null || idB == null || !(idA instanceof String) || !(idB instanceof String)) {
                return false;
            }
            return idA.equals(idB);
        }

        public static <T> GraphObjectList<T> createList(JSONArray array, Class<T> graphObjectClass) {
            return new GraphObjectListImpl(array, graphObjectClass);
        }

        public static <T> GraphObjectList<T> createList(Class<T> graphObjectClass) {
            return Factory.createList(new JSONArray(), graphObjectClass);
        }

        private static <T extends GraphObject> T createGraphObjectProxy(Class<T> graphObjectClass, JSONObject state) {
            Factory.verifyCanProxyClass(graphObjectClass);
            Class[] interfaces = new Class[]{graphObjectClass};
            GraphObjectProxy graphObjectProxy = new GraphObjectProxy(state, graphObjectClass);
            GraphObject graphObject = (GraphObject)Proxy.newProxyInstance(GraphObject.class.getClassLoader(), interfaces, (InvocationHandler)graphObjectProxy);
            return (T)graphObject;
        }

        private static Map<String, Object> createGraphObjectProxyForMap(JSONObject state) {
            Class[] interfaces = new Class[]{Map.class};
            GraphObjectProxy graphObjectProxy = new GraphObjectProxy(state, Map.class);
            Map graphObject = (Map)Proxy.newProxyInstance(GraphObject.class.getClassLoader(), interfaces, (InvocationHandler)graphObjectProxy);
            return graphObject;
        }

        private static synchronized <T extends GraphObject> boolean hasClassBeenVerified(Class<T> graphObjectClass) {
            return verifiedGraphObjectClasses.contains(graphObjectClass);
        }

        private static synchronized <T extends GraphObject> void recordClassHasBeenVerified(Class<T> graphObjectClass) {
            verifiedGraphObjectClasses.add(graphObjectClass);
        }

        private static <T extends GraphObject> void verifyCanProxyClass(Class<T> graphObjectClass) {
            Method[] methods;
            if (Factory.hasClassBeenVerified(graphObjectClass)) {
                return;
            }
            if (!graphObjectClass.isInterface()) {
                throw new FacebookGraphObjectException("Factory can only wrap interfaces, not class: " + graphObjectClass.getName());
            }
            for (Method method : methods = graphObjectClass.getMethods()) {
                String methodName = method.getName();
                int parameterCount = method.getParameterTypes().length;
                Class<?> returnType = method.getReturnType();
                boolean hasPropertyNameOverride = method.isAnnotationPresent(PropertyName.class);
                if (method.getDeclaringClass().isAssignableFrom(GraphObject.class) || (parameterCount == 1 && returnType == Void.TYPE ? (hasPropertyNameOverride ? !Utility.isNullOrEmpty(method.getAnnotation(PropertyName.class).value()) : methodName.startsWith("set") && methodName.length() > 3) : parameterCount == 0 && returnType != Void.TYPE && (hasPropertyNameOverride ? !Utility.isNullOrEmpty(method.getAnnotation(PropertyName.class).value()) : methodName.startsWith("get") && methodName.length() > 3))) continue;
                throw new FacebookGraphObjectException("Factory can't proxy method: " + method.toString());
            }
            Factory.recordClassHasBeenVerified(graphObjectClass);
        }

        static <U> U coerceValueToExpectedType(Object value, Class<U> expectedType, ParameterizedType expectedTypeAsParameterizedType) {
            if (value == null) {
                if (Boolean.TYPE.equals(expectedType)) {
                    Boolean result = false;
                    return (U)result;
                }
                if (Character.TYPE.equals(expectedType)) {
                    Character result = Character.valueOf('\u0000');
                    return (U)result;
                }
                if (expectedType.isPrimitive()) {
                    Integer result = 0;
                    return (U)result;
                }
                return null;
            }
            Class<?> valueType = value.getClass();
            if (expectedType.isAssignableFrom(valueType)) {
                Object result = value;
                return (U)result;
            }
            if (expectedType.isPrimitive()) {
                Object result = value;
                return (U)result;
            }
            if (GraphObject.class.isAssignableFrom(expectedType)) {
                Class<U> graphObjectClass = expectedType;
                if (JSONObject.class.isAssignableFrom(valueType)) {
                    U result = Factory.createGraphObjectProxy(graphObjectClass, (JSONObject)value);
                    return result;
                }
                if (GraphObject.class.isAssignableFrom(valueType)) {
                    U result = ((GraphObject)value).cast(graphObjectClass);
                    return result;
                }
                throw new FacebookGraphObjectException("Can't create GraphObject from " + valueType.getName());
            }
            if (Iterable.class.equals(expectedType) || Collection.class.equals(expectedType) || List.class.equals(expectedType) || GraphObjectList.class.equals(expectedType)) {
                if (expectedTypeAsParameterizedType == null) {
                    throw new FacebookGraphObjectException("can't infer generic type of: " + expectedType.toString());
                }
                Type[] actualTypeArguments = expectedTypeAsParameterizedType.getActualTypeArguments();
                if (actualTypeArguments == null || actualTypeArguments.length != 1 || !(actualTypeArguments[0] instanceof Class)) {
                    throw new FacebookGraphObjectException("Expect collection properties to be of a type with exactly one generic parameter.");
                }
                Class collectionGenericArgument = (Class)actualTypeArguments[0];
                if (JSONArray.class.isAssignableFrom(valueType)) {
                    JSONArray jsonArray = (JSONArray)value;
                    GraphObjectList result = Factory.createList(jsonArray, collectionGenericArgument);
                    return (U)result;
                }
                throw new FacebookGraphObjectException("Can't create Collection from " + valueType.getName());
            }
            if (String.class.equals(expectedType)) {
                if (Double.class.isAssignableFrom(valueType) || Float.class.isAssignableFrom(valueType)) {
                    String result = String.format("%f", value);
                    return (U)result;
                }
                if (Number.class.isAssignableFrom(valueType)) {
                    String result = String.format("%d", value);
                    return (U)result;
                }
            } else if (Date.class.equals(expectedType) && String.class.isAssignableFrom(valueType)) {
                for (SimpleDateFormat format : dateFormats) {
                    try {
                        Date date = format.parse((String)value);
                        if (date != null) {
                            Date result = date;
                            return (U)result;
                        }
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
            }
            throw new FacebookGraphObjectException("Can't convert type" + valueType.getName() + " to " + expectedType.getName());
        }

        static String convertCamelCaseToLowercaseWithUnderscores(String string2) {
            string2 = string2.replaceAll("([a-z])([A-Z])", "$1_$2");
            return string2.toLowerCase(Locale.US);
        }

        private static Object getUnderlyingJSONObject(Object obj) {
            if (obj == null) {
                return null;
            }
            Class<?> objClass = obj.getClass();
            if (GraphObject.class.isAssignableFrom(objClass)) {
                GraphObject graphObject = (GraphObject)obj;
                return graphObject.getInnerJSONObject();
            }
            if (GraphObjectList.class.isAssignableFrom(objClass)) {
                GraphObjectList graphObjectList = (GraphObjectList)obj;
                return graphObjectList.getInnerJSONArray();
            }
            if (Iterable.class.isAssignableFrom(objClass)) {
                JSONArray jsonArray = new JSONArray();
                Iterable iterable = (Iterable)obj;
                for (Object o : iterable) {
                    if (GraphObject.class.isAssignableFrom(o.getClass())) {
                        jsonArray.put((Object)((GraphObject)o).getInnerJSONObject());
                        continue;
                    }
                    jsonArray.put(o);
                }
                return jsonArray;
            }
            return obj;
        }

        private static final class GraphObjectListImpl<T>
        extends AbstractList<T>
        implements GraphObjectList<T> {
            private final JSONArray state;
            private final Class<?> itemType;

            public GraphObjectListImpl(JSONArray state, Class<?> itemType) {
                Validate.notNull(state, "state");
                Validate.notNull(itemType, "itemType");
                this.state = state;
                this.itemType = itemType;
            }

            @Override
            public String toString() {
                return String.format("GraphObjectList{itemType=%s, state=%s}", this.itemType.getSimpleName(), this.state);
            }

            @Override
            public void add(int location, T object) {
                if (location < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (location < this.size()) {
                    throw new UnsupportedOperationException("Only adding items at the end of the list is supported.");
                }
                this.put(location, object);
            }

            @Override
            public T set(int location, T object) {
                this.checkIndex(location);
                T result = this.get(location);
                this.put(location, object);
                return result;
            }

            @Override
            public int hashCode() {
                return this.state.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this == obj) {
                    return true;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                GraphObjectListImpl other = (GraphObjectListImpl)obj;
                return this.state.equals(other.state);
            }

            @Override
            public T get(int location) {
                this.checkIndex(location);
                Object value = this.state.opt(location);
                Object result = Factory.coerceValueToExpectedType(value, this.itemType, null);
                return (T)result;
            }

            @Override
            public int size() {
                return this.state.length();
            }

            @Override
            public final <U extends GraphObject> GraphObjectList<U> castToListOf(Class<U> graphObjectClass) {
                if (GraphObject.class.isAssignableFrom(this.itemType)) {
                    if (graphObjectClass.isAssignableFrom(this.itemType)) {
                        GraphObjectListImpl result = this;
                        return result;
                    }
                    return Factory.createList(this.state, graphObjectClass);
                }
                throw new FacebookGraphObjectException("Can't cast GraphObjectCollection of non-GraphObject type " + this.itemType);
            }

            @Override
            public final JSONArray getInnerJSONArray() {
                return this.state;
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            private void checkIndex(int index) {
                if (index < 0 || index >= this.state.length()) {
                    throw new IndexOutOfBoundsException();
                }
            }

            private void put(int index, T obj) {
                Object underlyingObject = Factory.getUnderlyingJSONObject(obj);
                try {
                    this.state.put(index, underlyingObject);
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }

        private static final class GraphObjectProxy
        extends ProxyBase<JSONObject> {
            private static final String CLEAR_METHOD = "clear";
            private static final String CONTAINSKEY_METHOD = "containsKey";
            private static final String CONTAINSVALUE_METHOD = "containsValue";
            private static final String ENTRYSET_METHOD = "entrySet";
            private static final String GET_METHOD = "get";
            private static final String ISEMPTY_METHOD = "isEmpty";
            private static final String KEYSET_METHOD = "keySet";
            private static final String PUT_METHOD = "put";
            private static final String PUTALL_METHOD = "putAll";
            private static final String REMOVE_METHOD = "remove";
            private static final String SIZE_METHOD = "size";
            private static final String VALUES_METHOD = "values";
            private static final String CAST_METHOD = "cast";
            private static final String CASTTOMAP_METHOD = "asMap";
            private static final String GETPROPERTY_METHOD = "getProperty";
            private static final String GETPROPERTYAS_METHOD = "getPropertyAs";
            private static final String GETPROPERTYASLIST_METHOD = "getPropertyAsList";
            private static final String SETPROPERTY_METHOD = "setProperty";
            private static final String REMOVEPROPERTY_METHOD = "removeProperty";
            private static final String GETINNERJSONOBJECT_METHOD = "getInnerJSONObject";
            private final Class<?> graphObjectClass;

            public GraphObjectProxy(JSONObject state, Class<?> graphObjectClass) {
                super(state);
                this.graphObjectClass = graphObjectClass;
            }

            public String toString() {
                return String.format("GraphObject{graphObjectClass=%s, state=%s}", this.graphObjectClass.getSimpleName(), this.state);
            }

            @Override
            public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Class<?> declaringClass = method.getDeclaringClass();
                if (declaringClass == Object.class) {
                    return this.proxyObjectMethods(proxy, method, args);
                }
                if (declaringClass == Map.class) {
                    return this.proxyMapMethods(method, args);
                }
                if (declaringClass == GraphObject.class) {
                    return this.proxyGraphObjectMethods(proxy, method, args);
                }
                if (GraphObject.class.isAssignableFrom(declaringClass)) {
                    return this.proxyGraphObjectGettersAndSetters(method, args);
                }
                return this.throwUnexpectedMethodSignature(method);
            }

            private final Object proxyMapMethods(Method method, Object[] args) {
                String methodName = method.getName();
                if (methodName.equals(CLEAR_METHOD)) {
                    JsonUtil.jsonObjectClear((JSONObject)this.state);
                    return null;
                }
                if (methodName.equals(CONTAINSKEY_METHOD)) {
                    return ((JSONObject)this.state).has((String)args[0]);
                }
                if (methodName.equals(CONTAINSVALUE_METHOD)) {
                    return JsonUtil.jsonObjectContainsValue((JSONObject)this.state, args[0]);
                }
                if (methodName.equals(ENTRYSET_METHOD)) {
                    return JsonUtil.jsonObjectEntrySet((JSONObject)this.state);
                }
                if (methodName.equals(GET_METHOD)) {
                    return ((JSONObject)this.state).opt((String)args[0]);
                }
                if (methodName.equals(ISEMPTY_METHOD)) {
                    return ((JSONObject)this.state).length() == 0;
                }
                if (methodName.equals(KEYSET_METHOD)) {
                    return JsonUtil.jsonObjectKeySet((JSONObject)this.state);
                }
                if (methodName.equals(PUT_METHOD)) {
                    return this.setJSONProperty(args);
                }
                if (methodName.equals(PUTALL_METHOD)) {
                    Map<String, Object> map = null;
                    if (args[0] instanceof Map) {
                        Map<String, Object> castMap;
                        map = castMap = (Map<String, Object>)args[0];
                    } else if (args[0] instanceof GraphObject) {
                        map = ((GraphObject)args[0]).asMap();
                    } else {
                        return null;
                    }
                    JsonUtil.jsonObjectPutAll((JSONObject)this.state, map);
                    return null;
                }
                if (methodName.equals(REMOVE_METHOD)) {
                    ((JSONObject)this.state).remove((String)args[0]);
                    return null;
                }
                if (methodName.equals(SIZE_METHOD)) {
                    return ((JSONObject)this.state).length();
                }
                if (methodName.equals(VALUES_METHOD)) {
                    return JsonUtil.jsonObjectValues((JSONObject)this.state);
                }
                return this.throwUnexpectedMethodSignature(method);
            }

            private final Object proxyGraphObjectMethods(Object proxy, Method method, Object[] args) {
                String methodName = method.getName();
                if (methodName.equals(CAST_METHOD)) {
                    Class graphObjectClass = (Class)args[0];
                    if (graphObjectClass != null && graphObjectClass.isAssignableFrom(this.graphObjectClass)) {
                        return proxy;
                    }
                    return Factory.createGraphObjectProxy(graphObjectClass, (JSONObject)this.state);
                }
                if (methodName.equals(GETINNERJSONOBJECT_METHOD)) {
                    InvocationHandler handler = Proxy.getInvocationHandler(proxy);
                    GraphObjectProxy otherProxy = (GraphObjectProxy)handler;
                    return otherProxy.state;
                }
                if (methodName.equals(CASTTOMAP_METHOD)) {
                    return Factory.createGraphObjectProxyForMap((JSONObject)this.state);
                }
                if (methodName.equals(GETPROPERTY_METHOD)) {
                    return ((JSONObject)this.state).opt((String)args[0]);
                }
                if (methodName.equals(GETPROPERTYAS_METHOD)) {
                    Object value = ((JSONObject)this.state).opt((String)args[0]);
                    Class expectedType = (Class)args[1];
                    return Factory.coerceValueToExpectedType(value, expectedType, null);
                }
                if (methodName.equals(GETPROPERTYASLIST_METHOD)) {
                    Object value = ((JSONObject)this.state).opt((String)args[0]);
                    final Class expectedType = (Class)args[1];
                    ParameterizedType parameterizedType = new ParameterizedType(){

                        @Override
                        public Type[] getActualTypeArguments() {
                            return new Type[]{expectedType};
                        }

                        @Override
                        public Type getOwnerType() {
                            return null;
                        }

                        @Override
                        public Type getRawType() {
                            return GraphObjectList.class;
                        }
                    };
                    return Factory.coerceValueToExpectedType(value, GraphObjectList.class, parameterizedType);
                }
                if (methodName.equals(SETPROPERTY_METHOD)) {
                    return this.setJSONProperty(args);
                }
                if (methodName.equals(REMOVEPROPERTY_METHOD)) {
                    ((JSONObject)this.state).remove((String)args[0]);
                    return null;
                }
                return this.throwUnexpectedMethodSignature(method);
            }

            private Object createGraphObjectsFromParameters(CreateGraphObject createGraphObject, Object value) {
                if (createGraphObject != null && !Utility.isNullOrEmpty(createGraphObject.value())) {
                    String propertyName = createGraphObject.value();
                    if (List.class.isAssignableFrom(value.getClass())) {
                        GraphObjectList<GraphObject> graphObjects = Factory.createList(GraphObject.class);
                        List values = value;
                        for (Object obj : values) {
                            GraphObject graphObject = Factory.create();
                            graphObject.setProperty(propertyName, obj);
                            graphObjects.add(graphObject);
                        }
                        value = graphObjects;
                    } else {
                        GraphObject graphObject = Factory.create();
                        graphObject.setProperty(propertyName, value);
                        value = graphObject;
                    }
                }
                return value;
            }

            private final Object proxyGraphObjectGettersAndSetters(Method method, Object[] args) throws JSONException {
                String key;
                String methodName = method.getName();
                int parameterCount = method.getParameterTypes().length;
                PropertyName propertyNameOverride = method.getAnnotation(PropertyName.class);
                String string2 = key = propertyNameOverride != null ? propertyNameOverride.value() : Factory.convertCamelCaseToLowercaseWithUnderscores(methodName.substring(3));
                if (parameterCount == 0) {
                    Object value = ((JSONObject)this.state).opt(key);
                    Class<?> expectedType = method.getReturnType();
                    Type genericReturnType = method.getGenericReturnType();
                    ParameterizedType parameterizedReturnType = null;
                    if (genericReturnType instanceof ParameterizedType) {
                        parameterizedReturnType = (ParameterizedType)genericReturnType;
                    }
                    value = Factory.coerceValueToExpectedType(value, expectedType, parameterizedReturnType);
                    return value;
                }
                if (parameterCount == 1) {
                    CreateGraphObject createGraphObjectAnnotation = method.getAnnotation(CreateGraphObject.class);
                    Object value = this.createGraphObjectsFromParameters(createGraphObjectAnnotation, args[0]);
                    value = Factory.getUnderlyingJSONObject(value);
                    ((JSONObject)this.state).putOpt(key, value);
                    return null;
                }
                return this.throwUnexpectedMethodSignature(method);
            }

            private Object setJSONProperty(Object[] args) {
                String name = (String)args[0];
                Object property = args[1];
                Object value = Factory.getUnderlyingJSONObject(property);
                try {
                    ((JSONObject)this.state).putOpt(name, value);
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException(e);
                }
                return null;
            }
        }

        private static abstract class ProxyBase<STATE>
        implements InvocationHandler {
            private static final String EQUALS_METHOD = "equals";
            private static final String TOSTRING_METHOD = "toString";
            protected final STATE state;

            protected ProxyBase(STATE state) {
                this.state = state;
            }

            protected final Object throwUnexpectedMethodSignature(Method method) {
                throw new FacebookGraphObjectException(this.getClass().getName() + " got an unexpected method signature: " + method.toString());
            }

            protected final Object proxyObjectMethods(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (methodName.equals(EQUALS_METHOD)) {
                    Object other = args[0];
                    if (other == null) {
                        return false;
                    }
                    InvocationHandler handler = Proxy.getInvocationHandler(other);
                    if (!(handler instanceof GraphObjectProxy)) {
                        return false;
                    }
                    GraphObjectProxy otherProxy = (GraphObjectProxy)handler;
                    return this.state.equals(otherProxy.state);
                }
                if (methodName.equals(TOSTRING_METHOD)) {
                    return this.toString();
                }
                return method.invoke(this.state, args);
            }
        }
    }
}

