/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.LoggingBehavior;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Session;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Response {
    private final HttpURLConnection connection;
    private final GraphObject graphObject;
    private final GraphObjectList<GraphObject> graphObjectList;
    private final boolean isFromCache;
    private final FacebookRequestError error;
    private final String rawResponse;
    private final Request request;
    public static final String NON_JSON_RESPONSE_PROPERTY = "FACEBOOK_NON_JSON_RESULT";
    public static final String SUCCESS_KEY = "success";
    private static final int INVALID_SESSION_FACEBOOK_ERROR_CODE = 190;
    private static final String CODE_KEY = "code";
    private static final String BODY_KEY = "body";
    private static final String RESPONSE_LOG_TAG = "Response";
    private static final String RESPONSE_CACHE_TAG = "ResponseCache";
    private static FileLruCache responseCache;

    Response(Request request, HttpURLConnection connection, String rawResponse, GraphObject graphObject, boolean isFromCache) {
        this(request, connection, rawResponse, graphObject, null, isFromCache, null);
    }

    Response(Request request, HttpURLConnection connection, String rawResponse, GraphObjectList<GraphObject> graphObjects, boolean isFromCache) {
        this(request, connection, rawResponse, null, graphObjects, isFromCache, null);
    }

    Response(Request request, HttpURLConnection connection, FacebookRequestError error) {
        this(request, connection, null, null, null, false, error);
    }

    Response(Request request, HttpURLConnection connection, String rawResponse, GraphObject graphObject, GraphObjectList<GraphObject> graphObjects, boolean isFromCache, FacebookRequestError error) {
        this.request = request;
        this.connection = connection;
        this.rawResponse = rawResponse;
        this.graphObject = graphObject;
        this.graphObjectList = graphObjects;
        this.isFromCache = isFromCache;
        this.error = error;
    }

    public final FacebookRequestError getError() {
        return this.error;
    }

    public final GraphObject getGraphObject() {
        return this.graphObject;
    }

    public final <T extends GraphObject> T getGraphObjectAs(Class<T> graphObjectClass) {
        if (this.graphObject == null) {
            return null;
        }
        if (graphObjectClass == null) {
            throw new NullPointerException("Must pass in a valid interface that extends GraphObject");
        }
        return this.graphObject.cast(graphObjectClass);
    }

    public final GraphObjectList<GraphObject> getGraphObjectList() {
        return this.graphObjectList;
    }

    public final <T extends GraphObject> GraphObjectList<T> getGraphObjectListAs(Class<T> graphObjectClass) {
        if (this.graphObjectList == null) {
            return null;
        }
        return this.graphObjectList.castToListOf(graphObjectClass);
    }

    public final HttpURLConnection getConnection() {
        return this.connection;
    }

    public Request getRequest() {
        return this.request;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public Request getRequestForPagedResults(PagingDirection direction) {
        Request pagingRequest;
        PagedResults pagedResults;
        PagingInfo pagingInfo;
        String link = null;
        if (this.graphObject != null && (pagingInfo = (pagedResults = this.graphObject.cast(PagedResults.class)).getPaging()) != null) {
            link = direction == PagingDirection.NEXT ? pagingInfo.getNext() : pagingInfo.getPrevious();
        }
        if (Utility.isNullOrEmpty(link)) {
            return null;
        }
        if (link != null && link.equals(this.request.getUrlForSingleRequest())) {
            return null;
        }
        try {
            pagingRequest = new Request(this.request.getSession(), new URL(link));
        }
        catch (MalformedURLException e) {
            return null;
        }
        return pagingRequest;
    }

    public String toString() {
        String responseCode;
        try {
            responseCode = String.format("%d", this.connection != null ? this.connection.getResponseCode() : 200);
        }
        catch (IOException e) {
            responseCode = "unknown";
        }
        return "{Response: " + " responseCode: " + responseCode + ", graphObject: " + this.graphObject + ", error: " + this.error + ", isFromCache:" + this.isFromCache + "}";
    }

    public final boolean getIsFromCache() {
        return this.isFromCache;
    }

    static FileLruCache getResponseCache() {
        Context applicationContext;
        if (responseCache == null && (applicationContext = Session.getStaticContext()) != null) {
            responseCache = new FileLruCache(applicationContext, RESPONSE_CACHE_TAG, new FileLruCache.Limits());
        }
        return responseCache;
    }

    /*
     * Exception decompiling
     */
    static List<Response> fromHttpConnection(HttpURLConnection connection, RequestBatch requests) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static List<Response> createResponsesFromStream(InputStream stream, HttpURLConnection connection, RequestBatch requests, boolean isFromCache) throws FacebookException, JSONException, IOException {
        String responseString = Utility.readStreamToString(stream);
        Logger.log(LoggingBehavior.INCLUDE_RAW_RESPONSES, RESPONSE_LOG_TAG, "Response (raw)\n  Size: %d\n  Response:\n%s\n", responseString.length(), responseString);
        return Response.createResponsesFromString(responseString, connection, requests, isFromCache);
    }

    static List<Response> createResponsesFromString(String responseString, HttpURLConnection connection, RequestBatch requests, boolean isFromCache) throws FacebookException, JSONException, IOException {
        JSONTokener tokener = new JSONTokener(responseString);
        Object resultObject = tokener.nextValue();
        List<Response> responses = Response.createResponsesFromObject(connection, requests, resultObject, isFromCache);
        Logger.log(LoggingBehavior.REQUESTS, RESPONSE_LOG_TAG, "Response\n  Id: %s\n  Size: %d\n  Responses:\n%s\n", requests.getId(), responseString.length(), responses);
        return responses;
    }

    private static List<Response> createResponsesFromObject(HttpURLConnection connection, List<Request> requests, Object object, boolean isFromCache) throws FacebookException, JSONException {
        assert (connection != null || isFromCache);
        int numRequests = requests.size();
        ArrayList<Response> responses = new ArrayList<Response>(numRequests);
        Object originalResult = object;
        if (numRequests == 1) {
            Request request = requests.get(0);
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(BODY_KEY, object);
                int responseCode = connection != null ? connection.getResponseCode() : 200;
                jsonObject.put(CODE_KEY, responseCode);
                JSONArray jsonArray = new JSONArray();
                jsonArray.put((Object)jsonObject);
                object = jsonArray;
            }
            catch (JSONException e) {
                responses.add(new Response(request, connection, new FacebookRequestError(connection, (Exception)((Object)e))));
            }
            catch (IOException e) {
                responses.add(new Response(request, connection, new FacebookRequestError(connection, e)));
            }
        }
        if (!(object instanceof JSONArray) || ((JSONArray)object).length() != numRequests) {
            FacebookException exception = new FacebookException("Unexpected number of results");
            throw exception;
        }
        JSONArray jsonArray = (JSONArray)object;
        for (int i = 0; i < jsonArray.length(); ++i) {
            Request request = requests.get(i);
            try {
                Object obj = jsonArray.get(i);
                responses.add(Response.createResponseFromObject(request, connection, obj, isFromCache, originalResult));
                continue;
            }
            catch (JSONException e) {
                responses.add(new Response(request, connection, new FacebookRequestError(connection, (Exception)((Object)e))));
                continue;
            }
            catch (FacebookException e) {
                responses.add(new Response(request, connection, new FacebookRequestError(connection, e)));
            }
        }
        return responses;
    }

    private static Response createResponseFromObject(Request request, HttpURLConnection connection, Object object, boolean isFromCache, Object originalResult) throws JSONException {
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            FacebookRequestError error = FacebookRequestError.checkResponseAndCreateError(jsonObject, originalResult, connection);
            if (error != null) {
                Session session;
                if (error.getErrorCode() == 190 && (session = request.getSession()) != null) {
                    session.closeAndClearTokenInformation();
                }
                return new Response(request, connection, error);
            }
            Object body = Utility.getStringPropertyAsJSON(jsonObject, BODY_KEY, NON_JSON_RESPONSE_PROPERTY);
            if (body instanceof JSONObject) {
                GraphObject graphObject = GraphObject.Factory.create((JSONObject)body);
                return new Response(request, connection, body.toString(), graphObject, isFromCache);
            }
            if (body instanceof JSONArray) {
                GraphObjectList<GraphObject> graphObjectList = GraphObject.Factory.createList((JSONArray)body, GraphObject.class);
                return new Response(request, connection, body.toString(), graphObjectList, isFromCache);
            }
            object = JSONObject.NULL;
        }
        if (object == JSONObject.NULL) {
            return new Response(request, connection, object.toString(), (GraphObject)null, isFromCache);
        }
        throw new FacebookException("Got unexpected object type in response, class: " + object.getClass().getSimpleName());
    }

    static List<Response> constructErrorResponses(List<Request> requests, HttpURLConnection connection, FacebookException error) {
        int count = requests.size();
        ArrayList<Response> responses = new ArrayList<Response>(count);
        for (int i = 0; i < count; ++i) {
            Response response = new Response(requests.get(i), connection, new FacebookRequestError(connection, error));
            responses.add(response);
        }
        return responses;
    }

    static interface PagedResults
    extends GraphObject {
        public GraphObjectList<GraphObject> getData();

        public PagingInfo getPaging();
    }

    static interface PagingInfo
    extends GraphObject {
        public String getNext();

        public String getPrevious();
    }

    public static enum PagingDirection {
        NEXT,
        PREVIOUS;

    }
}

