/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer.ejb;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.proxy.EnterpriseBeanProxyMethodHandler;
import org.jboss.weld.bean.proxy.EnterpriseProxyFactory;
import org.jboss.weld.bean.proxy.EnterpriseTargetBeanInstance;
import org.jboss.weld.bean.proxy.InjectionPointPropagatingEnterpriseTargetBeanInstance;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.security.NewInstanceAction;

public class SessionBeanProxyInstantiator<T>
implements Instantiator<T> {
    private final Class<T> proxyClass;
    private final SessionBean<T> bean;

    public SessionBeanProxyInstantiator(EnhancedAnnotatedType<T> type2, SessionBean<T> bean) {
        this.bean = bean;
        this.proxyClass = new EnterpriseProxyFactory(type2.getJavaClass(), bean).getProxyClass();
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager) {
        try {
            T instance = AccessController.doPrivileged(NewInstanceAction.of(this.proxyClass));
            if (!this.bean.getScope().equals(Dependent.class)) {
                ctx.push(instance);
            }
            ProxyFactory.setBeanInstance(this.bean.getBeanManager().getContextId(), instance, this.createEnterpriseTargetBeanInstance(), this.bean);
            return instance;
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof InstantiationException) {
                throw new WeldException(BeanLogger.LOG.proxyInstantiationFailed(this), e.getCause());
            }
            if (e.getCause() instanceof IllegalAccessException) {
                throw new WeldException(BeanLogger.LOG.proxyInstantiationBeanAccessFailed(this), e.getCause());
            }
            throw new WeldException(e.getCause());
        }
        catch (Exception e) {
            throw BeanLogger.LOG.sessionBeanProxyInstantiationFailed(this.bean, this.proxyClass, e);
        }
    }

    protected EnterpriseTargetBeanInstance createEnterpriseTargetBeanInstance() {
        if (this.bean.getEjbDescriptor().isStateless()) {
            return new InjectionPointPropagatingEnterpriseTargetBeanInstance(this.bean.getBeanClass(), new EnterpriseBeanProxyMethodHandler<T>(this.bean), this.bean.getBeanManager());
        }
        return new EnterpriseTargetBeanInstance(this.bean.getBeanClass(), new EnterpriseBeanProxyMethodHandler<T>(this.bean));
    }

    @Override
    public boolean hasInterceptorSupport() {
        return false;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return false;
    }

    public SessionBean<T> getBean() {
        return this.bean;
    }

    @Override
    public Constructor<T> getConstructor() {
        return null;
    }
}

