/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.events.AbstractAnnotatedTypeRegisteringEvent;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.literal.InterceptorBindingTypeLiteral;
import org.jboss.weld.literal.NormalScopeLiteral;
import org.jboss.weld.literal.QualifierLiteral;
import org.jboss.weld.literal.ScopeLiteral;
import org.jboss.weld.literal.StereotypeLiteral;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.util.annotated.AnnotatedTypeWrapper;

public class BeforeBeanDiscoveryImpl
extends AbstractAnnotatedTypeRegisteringEvent
implements BeforeBeanDiscovery {
    public static void fire(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        new BeforeBeanDiscoveryImpl(beanManager, deployment, bdaMapping, contexts).fire();
    }

    protected BeforeBeanDiscoveryImpl(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        super(beanManager, (Type)((Object)BeforeBeanDiscovery.class), bdaMapping, deployment, contexts);
    }

    @Override
    public void addQualifier(Class<? extends Annotation> bindingType) {
        this.checkWithinObserverNotification();
        this.getTypeStore().add(bindingType, QualifierLiteral.INSTANCE);
        this.getBeanManager().getServices().get(ClassTransformer.class).clearAnnotationData(bindingType);
        this.getBeanManager().getServices().get(MetaAnnotationStore.class).clearAnnotationData(bindingType);
        BootstrapLogger.LOG.addQualifierCalled(this.getReceiver(), bindingType);
    }

    @Override
    public void addInterceptorBinding(Class<? extends Annotation> bindingType, Annotation ... bindingTypeDef) {
        this.checkWithinObserverNotification();
        TypeStore typeStore = this.getTypeStore();
        typeStore.add(bindingType, InterceptorBindingTypeLiteral.INSTANCE);
        for (Annotation a : bindingTypeDef) {
            typeStore.add(bindingType, a);
        }
        this.getBeanManager().getServices().get(ClassTransformer.class).clearAnnotationData(bindingType);
        this.getBeanManager().getServices().get(MetaAnnotationStore.class).clearAnnotationData(bindingType);
        BootstrapLogger.LOG.addInterceptorBindingCalled(this.getReceiver(), bindingType);
    }

    @Override
    public void addScope(Class<? extends Annotation> scopeType, boolean normal, boolean passivating) {
        this.checkWithinObserverNotification();
        if (normal) {
            this.getTypeStore().add(scopeType, new NormalScopeLiteral(passivating));
        } else {
            if (passivating) {
                throw BootstrapLogger.LOG.passivatingNonNormalScopeIllegal(scopeType);
            }
            this.getTypeStore().add(scopeType, ScopeLiteral.INSTANCE);
        }
        this.getBeanManager().getServices().get(ClassTransformer.class).clearAnnotationData(scopeType);
        this.getBeanManager().getServices().get(MetaAnnotationStore.class).clearAnnotationData(scopeType);
        this.getBeanManager().getServices().get(ReflectionCache.class).cleanup();
        BootstrapLogger.LOG.addScopeCalled(this.getReceiver(), scopeType);
    }

    @Override
    public void addStereotype(Class<? extends Annotation> stereotype, Annotation ... stereotypeDef) {
        this.checkWithinObserverNotification();
        TypeStore typeStore = this.getTypeStore();
        typeStore.add(stereotype, StereotypeLiteral.INSTANCE);
        for (Annotation a : stereotypeDef) {
            typeStore.add(stereotype, a);
        }
        this.getBeanManager().getServices().get(ClassTransformer.class).clearAnnotationData(stereotype);
        this.getBeanManager().getServices().get(MetaAnnotationStore.class).clearAnnotationData(stereotype);
        BootstrapLogger.LOG.addStereoTypeCalled(this.getReceiver(), stereotype);
    }

    @Override
    public void addAnnotatedType(AnnotatedType<?> source) {
        this.checkWithinObserverNotification();
        this.addAnnotatedType(source, null);
    }

    @Override
    public void addAnnotatedType(AnnotatedType<?> type2, String id) {
        this.checkWithinObserverNotification();
        this.addSyntheticAnnotatedType(type2, id);
        BootstrapLogger.LOG.addAnnotatedTypeCalledInBBD(this.getReceiver(), type2);
    }

    @Override
    public void addQualifier(AnnotatedType<? extends Annotation> qualifier) {
        this.checkWithinObserverNotification();
        this.addSyntheticAnnotation(qualifier, QualifierLiteral.INSTANCE);
        BootstrapLogger.LOG.addQualifierCalled(this.getReceiver(), qualifier);
    }

    @Override
    public void addInterceptorBinding(AnnotatedType<? extends Annotation> bindingType) {
        this.checkWithinObserverNotification();
        this.addSyntheticAnnotation(bindingType, InterceptorBindingTypeLiteral.INSTANCE);
        BootstrapLogger.LOG.addInterceptorBindingCalled(this.getReceiver(), bindingType);
    }

    private <A extends Annotation> void addSyntheticAnnotation(AnnotatedType<A> annotation, Annotation requiredMetaAnnotation) {
        if (requiredMetaAnnotation != null && !annotation.isAnnotationPresent(requiredMetaAnnotation.annotationType())) {
            annotation = new AnnotatedTypeWrapper<A>(annotation, requiredMetaAnnotation);
        }
        this.getBeanManager().getServices().get(ClassTransformer.class).addSyntheticAnnotation(annotation, this.getBeanManager().getId());
        this.getBeanManager().getServices().get(MetaAnnotationStore.class).clearAnnotationData(annotation.getJavaClass());
    }
}

